/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoHandler;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoTributoDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimulacaoParcelamentoDTO {
    private Integer entidade;
    private Long idParcelamento;
    @NotNull(message="Informe o tipo cadastro")
    private @NotNull(message="Informe o tipo cadastro") Integer tipoCadastro;
    @NotNull(message="Informe o cadastro geral")
    private @NotNull(message="Informe o cadastro geral") Long cadastroGeral;
    @NotNull(message="Informe o tipo do parcelamento")
    private @NotNull(message="Informe o tipo do parcelamento") TipoParcelamento tipo;
    private Integer anoContrato = LocalDate.now().getYear();
    private Long numeroContrato;
    @NotNull(message="Informe o par\u00e2metro do parcelamento")
    private @NotNull(message="Informe o par\u00e2metro do parcelamento") Long idParametroParcelamento;
    private LocalDate dataParcelamento = LocalDate.now();
    @NotNull(message="Informe a data de correcao")
    private @NotNull(message="Informe a data de correcao") LocalDate dataCorrecao;
    @Min(value=1L, message="Informe um n\u00famero de parcelas")
    private @Min(value=1L, message="Informe um n\u00famero de parcelas") Integer numeroParcelas;
    @NotNull(message="Informe o par\u00e2metro de entrada")
    private @NotNull(message="Informe o par\u00e2metro de entrada") Long entrada;
    @NotNull(message="Informe o requerente")
    private @NotNull(message="Informe o requerente") Long requerente;
    private BigDecimal valorEntrada = BigDecimal.ZERO;
    private BigDecimal valorEntradaTela = BigDecimal.ZERO;
    private LocalDate dataEntrada = LocalDate.now();
    private Long anoProcesso;
    private Long numeroProcesso;
    private Integer anoProcessoPrazo;
    private Long numeroProcessoPrazo;
    private LocalDate dataProcessoPrazo;
    private LocalDate dataProcessoOrigem;
    private Long tipoDesconto;
    private BigDecimal percentualDesconto = BigDecimal.ZERO;
    private Boolean digitouDesconto;
    private Integer anoProcessoDesconto;
    private Long processoDesconto;
    private String observacao;
    private String observacaoUsuario;
    @NotEmpty(message="Informe ao menos um d\u00e9bito")
    private @NotEmpty(message="Informe ao menos um d\u00e9bito") List<Long> debitos = new ArrayList();
    @Min(value=1L, message="Total selecionado n\u00e3o deve ser zero")
    private @Min(value=1L, message="Total selecionado n\u00e3o deve ser zero") BigDecimal totalSelecionado = BigDecimal.ZERO;
    private BigDecimal valorDemaisParcelas = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal valorTotalAVista = BigDecimal.ZERO;
    private BigDecimal valorDescontos = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private List<ParcelamentoDebitoDTO> debitosParcelamento = new ArrayList();
    private List<ParcelaParcelamentoDTO> debitosParcelaTributoParcelamento = new ArrayList();
    private List<ParcelamentoTributoDTO> debitosTributoParcelamento = new ArrayList();
    private Boolean concedeDescontoNoPagamento = Boolean.FALSE;
    private String hash;
    private String tenant;
    private boolean executaMovimentacao = false;

    public Boolean hasProcessoPrazo() {
        return Optional.ofNullable(this.anoProcessoPrazo).isPresent() && this.anoProcessoPrazo > 0 && Optional.ofNullable(this.dataProcessoPrazo).isPresent() && Optional.ofNullable(this.numeroProcessoPrazo).isPresent() && this.numeroProcessoPrazo > 0L;
    }

    public static SimulacaoParcelamentoDTO from(AiseParcelamentoDTO parcelamentoDTO, SimulacaoParcelamentoDTO paramSimulacao) {
        SimulacaoParcelamentoDTO simulacao = new SimulacaoParcelamentoDTO();
        simulacao.setTipoCadastro(parcelamentoDTO.getTipoCadastro());
        simulacao.setCadastroGeral(parcelamentoDTO.getCadastroGeral());
        simulacao.setTipo(parcelamentoDTO.getTipo());
        simulacao.setAnoContrato(parcelamentoDTO.getAnoContrato());
        simulacao.setIdParametroParcelamento(paramSimulacao.getIdParametroParcelamento());
        simulacao.setDataParcelamento(parcelamentoDTO.getDataParcelamento());
        simulacao.setDataCorrecao(parcelamentoDTO.getDataCorrecao());
        simulacao.setNumeroParcelas(parcelamentoDTO.getNumeroParcela());
        simulacao.setEntrada(paramSimulacao.getEntrada());
        simulacao.setRequerente(parcelamentoDTO.getRequerente());
        simulacao.setValorEntrada(paramSimulacao.getValorEntrada());
        simulacao.setValorEntradaTela(parcelamentoDTO.getValorEntrada());
        simulacao.setDataEntrada(parcelamentoDTO.getDataEntrada());
        simulacao.setAnoProcesso(paramSimulacao.getAnoProcesso());
        simulacao.setNumeroProcesso(paramSimulacao.getNumeroProcesso());
        simulacao.setAnoProcessoPrazo(paramSimulacao.getAnoProcessoPrazo());
        simulacao.setNumeroProcessoPrazo(paramSimulacao.getNumeroProcessoPrazo());
        simulacao.setDataProcessoPrazo(paramSimulacao.getDataProcessoPrazo());
        simulacao.setDataProcessoOrigem(paramSimulacao.getDataProcessoOrigem());
        simulacao.setPercentualDesconto(paramSimulacao.getPercentualDesconto());
        simulacao.setDigitouDesconto(paramSimulacao.getDigitouDesconto());
        simulacao.setAnoProcessoDesconto(paramSimulacao.getAnoProcessoDesconto());
        simulacao.setProcessoDesconto(paramSimulacao.getProcessoDesconto());
        simulacao.setObservacao(paramSimulacao.getObservacao());
        simulacao.setObservacaoUsuario(paramSimulacao.getObservacaoUsuario());
        simulacao.getDebitos().addAll(paramSimulacao.getDebitos());
        simulacao.setTotalSelecionado(paramSimulacao.getTotalSelecionado());
        Optional.ofNullable(parcelamentoDTO.getDebitos()).ifPresent(aiseDebitos -> {
            simulacao.setDebitosParcelamento(SimulacaoParcelamentoDTO.ordenarPorDebitoParcelamento(aiseDebitos.stream().map(AiseDebitoParcelamentoDTO::toParcelamentoDebitoDTO).collect(Collectors.toList())));
            simulacao.setDebitosTributoParcelamento(SimulacaoParcelamentoDTO.ordenarPorDebitoTributo((List)ParcelamentoHandler.agruparPorTributo((List)aiseDebitos)));
            simulacao.setDebitosParcelaTributoParcelamento(SimulacaoParcelamentoDTO.ordenarPorDebitoParcelaTributo((List)ParcelamentoHandler.agruparPorParcela((List)aiseDebitos)));
        });
        simulacao.setValorDemaisParcelas();
        simulacao.setValorTotal();
        Optional.ofNullable(parcelamentoDTO.getDebitos()).ifPresent(debitos -> debitos.forEach(debito -> {
            simulacao.setValorDescontoPrincipal(simulacao.getValorDescontoPrincipal().add(debito.getValorDescontoPrincipal()));
            simulacao.setValorDescontoMulta(simulacao.getValorDescontoMulta().add(debito.getValorDescontoMulta()));
            simulacao.setValorDescontoJuros(simulacao.getValorDescontoJuros().add(debito.getValorDescontoJuros()));
            simulacao.setValorDescontoCorrecao(simulacao.getValorDescontoCorrecao().add(debito.getValorDescontoCorrecao()));
        }));
        simulacao.setValorDescontos();
        simulacao.setHash(DigestUtils.md5Hex((String)simulacao.toString()).toUpperCase());
        return simulacao;
    }

    public boolean verificaIntegridadeSimulacao() {
        return Optional.ofNullable(this.hash).isPresent() && this.hash.equalsIgnoreCase(DigestUtils.md5Hex((String)this.toString()));
    }

    public void ajustarValorEntrada(Boolean digitouValorEntrada, ParamParcelamento parametroParcelamento, BigDecimal valorEntradaCalculado) {
        if (digitouValorEntrada.booleanValue()) {
            if (this.getValorEntrada().compareTo(valorEntradaCalculado) < 0) {
                this.setValorEntrada(valorEntradaCalculado);
            } else if (parametroParcelamento.getEntradaValorIgual().booleanValue()) {
                this.setValorEntrada(valorEntradaCalculado);
            } else {
                this.setValorEntrada(this.getValorEntrada().max(parametroParcelamento.getValorMinimoParcela()));
            }
        }
    }

    private static List<ParcelamentoDebitoDTO> ordenarPorDebitoParcelamento(List<ParcelamentoDebitoDTO> lista) {
        Comparator<ParcelamentoDebitoDTO> comparator = Comparator.comparing(ParcelamentoDebitoDTO::getExercicio).thenComparing(ParcelamentoDebitoDTO::getTipoCadastro).thenComparing(ParcelamentoDebitoDTO::getCadastroGeral).thenComparing(ParcelamentoDebitoDTO::getGuiaRecolhimento).thenComparing(ParcelamentoDebitoDTO::getSubDivida);
        return lista.stream().sorted(comparator).collect(Collectors.toList());
    }

    private static List<ParcelamentoTributoDTO> ordenarPorDebitoTributo(List<ParcelamentoTributoDTO> lista) {
        Comparator<ParcelamentoTributoDTO> comparator = Comparator.comparing(ParcelamentoTributoDTO::getReceita);
        return lista.stream().sorted(comparator).collect(Collectors.toList());
    }

    private static List<ParcelaParcelamentoDTO> ordenarPorDebitoParcelaTributo(List<ParcelaParcelamentoDTO> lista) {
        lista.forEach(tributos -> tributos.setParcelaReceita(SimulacaoParcelamentoDTO.ordenarPorDebitoTributo((List)tributos.getParcelaReceita())));
        Comparator<ParcelaParcelamentoDTO> comparator = Comparator.comparing(ParcelaParcelamentoDTO::getParcela);
        return lista.stream().sorted(comparator).collect(Collectors.toList());
    }

    public void setValorDemaisParcelas() {
        this.valorDemaisParcelas = this.getDebitosParcelaTributoParcelamento().size() > 1 ? ((ParcelaParcelamentoDTO)this.getDebitosParcelaTributoParcelamento().get(1)).getValorTotal() : BigDecimal.ZERO;
    }

    public void setValorTotal() {
        this.valorTotal = this.getDebitosParcelaTributoParcelamento().stream().map(ParcelaParcelamentoDTO::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void setValorDescontos() {
        this.valorDescontos = this.getValorDescontoPrincipal().add(this.getValorDescontoMulta()).add(this.getValorDescontoJuros()).add(this.getValorDescontoCorrecao());
    }

    public void setValorTotalAvista() {
        this.valorTotalAVista = this.getDebitosParcelaTributoParcelamento().stream().map(ParcelaParcelamentoDTO::getValorAVista).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalSelecionado() {
        return this.totalSelecionado.setScale(2, RoundingMode.HALF_EVEN);
    }

    public BigDecimal getValorEntrada() {
        return this.valorEntrada.setScale(2, RoundingMode.HALF_EVEN);
    }

    public static String getChaveParcelamentoAssincrono(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        return String.format("%s/%s/%s/%s", simulacaoParcelamentoDTO.getHash(), simulacaoParcelamentoDTO.getTipoCadastro(), simulacaoParcelamentoDTO.getCadastroGeral(), simulacaoParcelamentoDTO.getDataParcelamento());
    }

    @Generated
    public SimulacaoParcelamentoDTO() {
    }

    @Generated
    public Integer getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    @Generated
    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    @Generated
    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    @Generated
    public LocalDate getDataCorrecao() {
        return this.dataCorrecao;
    }

    @Generated
    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    @Generated
    public Long getEntrada() {
        return this.entrada;
    }

    @Generated
    public Long getRequerente() {
        return this.requerente;
    }

    @Generated
    public BigDecimal getValorEntradaTela() {
        return this.valorEntradaTela;
    }

    @Generated
    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    @Generated
    public Long getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public Long getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public Integer getAnoProcessoPrazo() {
        return this.anoProcessoPrazo;
    }

    @Generated
    public Long getNumeroProcessoPrazo() {
        return this.numeroProcessoPrazo;
    }

    @Generated
    public LocalDate getDataProcessoPrazo() {
        return this.dataProcessoPrazo;
    }

    @Generated
    public LocalDate getDataProcessoOrigem() {
        return this.dataProcessoOrigem;
    }

    @Generated
    public Long getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public BigDecimal getPercentualDesconto() {
        return this.percentualDesconto;
    }

    @Generated
    public Boolean getDigitouDesconto() {
        return this.digitouDesconto;
    }

    @Generated
    public Integer getAnoProcessoDesconto() {
        return this.anoProcessoDesconto;
    }

    @Generated
    public Long getProcessoDesconto() {
        return this.processoDesconto;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObservacaoUsuario() {
        return this.observacaoUsuario;
    }

    @Generated
    public List<Long> getDebitos() {
        return this.debitos;
    }

    @Generated
    public BigDecimal getValorDemaisParcelas() {
        return this.valorDemaisParcelas;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public BigDecimal getValorTotalAVista() {
        return this.valorTotalAVista;
    }

    @Generated
    public BigDecimal getValorDescontos() {
        return this.valorDescontos;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public List<ParcelamentoDebitoDTO> getDebitosParcelamento() {
        return this.debitosParcelamento;
    }

    @Generated
    public List<ParcelaParcelamentoDTO> getDebitosParcelaTributoParcelamento() {
        return this.debitosParcelaTributoParcelamento;
    }

    @Generated
    public List<ParcelamentoTributoDTO> getDebitosTributoParcelamento() {
        return this.debitosTributoParcelamento;
    }

    @Generated
    public Boolean getConcedeDescontoNoPagamento() {
        return this.concedeDescontoNoPagamento;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public boolean isExecutaMovimentacao() {
        return this.executaMovimentacao;
    }

    @Generated
    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    @Generated
    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    @Generated
    public void setDataCorrecao(LocalDate dataCorrecao) {
        this.dataCorrecao = dataCorrecao;
    }

    @Generated
    public void setNumeroParcelas(Integer numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @Generated
    public void setEntrada(Long entrada) {
        this.entrada = entrada;
    }

    @Generated
    public void setRequerente(Long requerente) {
        this.requerente = requerente;
    }

    @Generated
    public void setValorEntrada(BigDecimal valorEntrada) {
        this.valorEntrada = valorEntrada;
    }

    @Generated
    public void setValorEntradaTela(BigDecimal valorEntradaTela) {
        this.valorEntradaTela = valorEntradaTela;
    }

    @Generated
    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Generated
    public void setAnoProcesso(Long anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setAnoProcessoPrazo(Integer anoProcessoPrazo) {
        this.anoProcessoPrazo = anoProcessoPrazo;
    }

    @Generated
    public void setNumeroProcessoPrazo(Long numeroProcessoPrazo) {
        this.numeroProcessoPrazo = numeroProcessoPrazo;
    }

    @Generated
    public void setDataProcessoPrazo(LocalDate dataProcessoPrazo) {
        this.dataProcessoPrazo = dataProcessoPrazo;
    }

    @Generated
    public void setDataProcessoOrigem(LocalDate dataProcessoOrigem) {
        this.dataProcessoOrigem = dataProcessoOrigem;
    }

    @Generated
    public void setTipoDesconto(Long tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Generated
    public void setPercentualDesconto(BigDecimal percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    @Generated
    public void setDigitouDesconto(Boolean digitouDesconto) {
        this.digitouDesconto = digitouDesconto;
    }

    @Generated
    public void setAnoProcessoDesconto(Integer anoProcessoDesconto) {
        this.anoProcessoDesconto = anoProcessoDesconto;
    }

    @Generated
    public void setProcessoDesconto(Long processoDesconto) {
        this.processoDesconto = processoDesconto;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObservacaoUsuario(String observacaoUsuario) {
        this.observacaoUsuario = observacaoUsuario;
    }

    @Generated
    public void setDebitos(List<Long> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setTotalSelecionado(BigDecimal totalSelecionado) {
        this.totalSelecionado = totalSelecionado;
    }

    @Generated
    public void setValorDemaisParcelas(BigDecimal valorDemaisParcelas) {
        this.valorDemaisParcelas = valorDemaisParcelas;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalAVista(BigDecimal valorTotalAVista) {
        this.valorTotalAVista = valorTotalAVista;
    }

    @Generated
    public void setValorDescontos(BigDecimal valorDescontos) {
        this.valorDescontos = valorDescontos;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setDebitosParcelamento(List<ParcelamentoDebitoDTO> debitosParcelamento) {
        this.debitosParcelamento = debitosParcelamento;
    }

    @Generated
    public void setDebitosParcelaTributoParcelamento(List<ParcelaParcelamentoDTO> debitosParcelaTributoParcelamento) {
        this.debitosParcelaTributoParcelamento = debitosParcelaTributoParcelamento;
    }

    @Generated
    public void setDebitosTributoParcelamento(List<ParcelamentoTributoDTO> debitosTributoParcelamento) {
        this.debitosTributoParcelamento = debitosTributoParcelamento;
    }

    @Generated
    public void setConcedeDescontoNoPagamento(Boolean concedeDescontoNoPagamento) {
        this.concedeDescontoNoPagamento = concedeDescontoNoPagamento;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public void setExecutaMovimentacao(boolean executaMovimentacao) {
        this.executaMovimentacao = executaMovimentacao;
    }

    @Generated
    public String toString() {
        return "SimulacaoParcelamentoDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipo=" + this.getTipo() + ", anoContrato=" + this.getAnoContrato() + ", idParametroParcelamento=" + this.getIdParametroParcelamento() + ", dataParcelamento=" + this.getDataParcelamento() + ", dataCorrecao=" + this.getDataCorrecao() + ", numeroParcelas=" + this.getNumeroParcelas() + ", entrada=" + this.getEntrada() + ", valorEntrada=" + this.getValorEntrada() + ", dataEntrada=" + this.getDataEntrada() + ", debitos=" + this.getDebitos() + ", totalSelecionado=" + this.getTotalSelecionado() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimulacaoParcelamentoDTO)) {
            return false;
        }
        SimulacaoParcelamentoDTO other = (SimulacaoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$tipoCadastro = this.getTipoCadastro();
        Integer other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Long this$idParametroParcelamento = this.getIdParametroParcelamento();
        Long other$idParametroParcelamento = other.getIdParametroParcelamento();
        if (this$idParametroParcelamento == null ? other$idParametroParcelamento != null : !((Object)this$idParametroParcelamento).equals(other$idParametroParcelamento)) {
            return false;
        }
        Long this$entrada = this.getEntrada();
        Long other$entrada = other.getEntrada();
        if (this$entrada == null ? other$entrada != null : !((Object)this$entrada).equals(other$entrada)) {
            return false;
        }
        TipoParcelamento this$tipo = this.getTipo();
        TipoParcelamento other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        LocalDate this$dataParcelamento = this.getDataParcelamento();
        LocalDate other$dataParcelamento = other.getDataParcelamento();
        if (this$dataParcelamento == null ? other$dataParcelamento != null : !((Object)this$dataParcelamento).equals(other$dataParcelamento)) {
            return false;
        }
        LocalDate this$dataCorrecao = this.getDataCorrecao();
        LocalDate other$dataCorrecao = other.getDataCorrecao();
        if (this$dataCorrecao == null ? other$dataCorrecao != null : !((Object)this$dataCorrecao).equals(other$dataCorrecao)) {
            return false;
        }
        BigDecimal this$valorEntrada = this.getValorEntrada();
        BigDecimal other$valorEntrada = other.getValorEntrada();
        if (this$valorEntrada == null ? other$valorEntrada != null : !((Object)this$valorEntrada).equals(other$valorEntrada)) {
            return false;
        }
        LocalDate this$dataEntrada = this.getDataEntrada();
        LocalDate other$dataEntrada = other.getDataEntrada();
        if (this$dataEntrada == null ? other$dataEntrada != null : !((Object)this$dataEntrada).equals(other$dataEntrada)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        BigDecimal this$totalSelecionado = this.getTotalSelecionado();
        BigDecimal other$totalSelecionado = other.getTotalSelecionado();
        return !(this$totalSelecionado == null ? other$totalSelecionado != null : !((Object)this$totalSelecionado).equals(other$totalSelecionado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimulacaoParcelamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Long $idParametroParcelamento = this.getIdParametroParcelamento();
        result = result * 59 + ($idParametroParcelamento == null ? 43 : ((Object)$idParametroParcelamento).hashCode());
        Long $entrada = this.getEntrada();
        result = result * 59 + ($entrada == null ? 43 : ((Object)$entrada).hashCode());
        TipoParcelamento $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        LocalDate $dataParcelamento = this.getDataParcelamento();
        result = result * 59 + ($dataParcelamento == null ? 43 : ((Object)$dataParcelamento).hashCode());
        LocalDate $dataCorrecao = this.getDataCorrecao();
        result = result * 59 + ($dataCorrecao == null ? 43 : ((Object)$dataCorrecao).hashCode());
        BigDecimal $valorEntrada = this.getValorEntrada();
        result = result * 59 + ($valorEntrada == null ? 43 : ((Object)$valorEntrada).hashCode());
        LocalDate $dataEntrada = this.getDataEntrada();
        result = result * 59 + ($dataEntrada == null ? 43 : ((Object)$dataEntrada).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        BigDecimal $totalSelecionado = this.getTotalSelecionado();
        result = result * 59 + ($totalSelecionado == null ? 43 : ((Object)$totalSelecionado).hashCode());
        return result;
    }
}

