/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestadaExercicio;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.dto.LogradouroDTO;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class LogradouroTestadaExercicioResumoDTO {
    private Long id;
    private Long logradouroTestadaId;
    private Long exercicio;
    private String distrito;
    private String setor;
    private String quadra;
    private String faceQuadra;
    private SetorQuadra setorQuadra;
    private Quadricula quadricula;
    private LogradouroDTO logradouro;
    private BigDecimal valorTerrenoIPTU = BigDecimal.ZERO;
    private BigDecimal valorTerrenoITBI = BigDecimal.ZERO;
    private BigDecimal outrosValores = BigDecimal.ZERO;
    private BigDecimal larguraRua = BigDecimal.ZERO;

    public static LogradouroTestadaExercicioResumoDTO from(LogradouroTestadaExercicio entity) {
        LogradouroTestadaExercicioResumoDTO dto = new LogradouroTestadaExercicioResumoDTO();
        dto.setId(entity.getId());
        dto.setLogradouroTestadaId(entity.getLogradouroTestada().getId());
        dto.setLogradouro(LogradouroDTO.from((Logradouro)entity.getLogradouroTestada().getLogradouro()));
        dto.setDistrito((String)Optional.ofNullable(entity.getLogradouroTestada().getSetorQuadra()).map(SetorQuadra::getSetor).map(Setor::getDistrito).map(Distrito::getDistrito).orElse(null));
        dto.setSetor((String)Optional.ofNullable(entity.getLogradouroTestada().getSetorQuadra()).map(SetorQuadra::getSetor).map(Setor::getSetor).orElse(null));
        dto.setQuadra((String)Optional.ofNullable(entity.getLogradouroTestada().getSetorQuadra()).map(SetorQuadra::getQuadra).orElse(null));
        dto.setFaceQuadra(entity.getLogradouroTestada().getFaceQuadra());
        dto.setSetorQuadra(entity.getLogradouroTestada().getSetorQuadra());
        dto.setValorTerrenoIPTU(entity.getValorTerreno());
        dto.setValorTerrenoITBI(entity.getValorTerrenoITBI());
        dto.setOutrosValores(entity.getValorTerrenoOutro());
        dto.setLarguraRua(entity.getLarguraRua());
        return dto;
    }

    @Generated
    public LogradouroTestadaExercicioResumoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getLogradouroTestadaId() {
        return this.logradouroTestadaId;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDistrito() {
        return this.distrito;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    @Generated
    public SetorQuadra getSetorQuadra() {
        return this.setorQuadra;
    }

    @Generated
    public Quadricula getQuadricula() {
        return this.quadricula;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BigDecimal getValorTerrenoIPTU() {
        return this.valorTerrenoIPTU;
    }

    @Generated
    public BigDecimal getValorTerrenoITBI() {
        return this.valorTerrenoITBI;
    }

    @Generated
    public BigDecimal getOutrosValores() {
        return this.outrosValores;
    }

    @Generated
    public BigDecimal getLarguraRua() {
        return this.larguraRua;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLogradouroTestadaId(Long logradouroTestadaId) {
        this.logradouroTestadaId = logradouroTestadaId;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    @Generated
    public void setSetorQuadra(SetorQuadra setorQuadra) {
        this.setorQuadra = setorQuadra;
    }

    @Generated
    public void setQuadricula(Quadricula quadricula) {
        this.quadricula = quadricula;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setValorTerrenoIPTU(BigDecimal valorTerrenoIPTU) {
        this.valorTerrenoIPTU = valorTerrenoIPTU;
    }

    @Generated
    public void setValorTerrenoITBI(BigDecimal valorTerrenoITBI) {
        this.valorTerrenoITBI = valorTerrenoITBI;
    }

    @Generated
    public void setOutrosValores(BigDecimal outrosValores) {
        this.outrosValores = outrosValores;
    }

    @Generated
    public void setLarguraRua(BigDecimal larguraRua) {
        this.larguraRua = larguraRua;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogradouroTestadaExercicioResumoDTO)) {
            return false;
        }
        LogradouroTestadaExercicioResumoDTO other = (LogradouroTestadaExercicioResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$logradouroTestadaId = this.getLogradouroTestadaId();
        Long other$logradouroTestadaId = other.getLogradouroTestadaId();
        if (this$logradouroTestadaId == null ? other$logradouroTestadaId != null : !((Object)this$logradouroTestadaId).equals(other$logradouroTestadaId)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$distrito = this.getDistrito();
        String other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$faceQuadra = this.getFaceQuadra();
        String other$faceQuadra = other.getFaceQuadra();
        if (this$faceQuadra == null ? other$faceQuadra != null : !this$faceQuadra.equals(other$faceQuadra)) {
            return false;
        }
        SetorQuadra this$setorQuadra = this.getSetorQuadra();
        SetorQuadra other$setorQuadra = other.getSetorQuadra();
        if (this$setorQuadra == null ? other$setorQuadra != null : !this$setorQuadra.equals(other$setorQuadra)) {
            return false;
        }
        Quadricula this$quadricula = this.getQuadricula();
        Quadricula other$quadricula = other.getQuadricula();
        if (this$quadricula == null ? other$quadricula != null : !this$quadricula.equals(other$quadricula)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        BigDecimal this$valorTerrenoIPTU = this.getValorTerrenoIPTU();
        BigDecimal other$valorTerrenoIPTU = other.getValorTerrenoIPTU();
        if (this$valorTerrenoIPTU == null ? other$valorTerrenoIPTU != null : !((Object)this$valorTerrenoIPTU).equals(other$valorTerrenoIPTU)) {
            return false;
        }
        BigDecimal this$valorTerrenoITBI = this.getValorTerrenoITBI();
        BigDecimal other$valorTerrenoITBI = other.getValorTerrenoITBI();
        if (this$valorTerrenoITBI == null ? other$valorTerrenoITBI != null : !((Object)this$valorTerrenoITBI).equals(other$valorTerrenoITBI)) {
            return false;
        }
        BigDecimal this$outrosValores = this.getOutrosValores();
        BigDecimal other$outrosValores = other.getOutrosValores();
        if (this$outrosValores == null ? other$outrosValores != null : !((Object)this$outrosValores).equals(other$outrosValores)) {
            return false;
        }
        BigDecimal this$larguraRua = this.getLarguraRua();
        BigDecimal other$larguraRua = other.getLarguraRua();
        return !(this$larguraRua == null ? other$larguraRua != null : !((Object)this$larguraRua).equals(other$larguraRua));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogradouroTestadaExercicioResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $logradouroTestadaId = this.getLogradouroTestadaId();
        result = result * 59 + ($logradouroTestadaId == null ? 43 : ((Object)$logradouroTestadaId).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $faceQuadra = this.getFaceQuadra();
        result = result * 59 + ($faceQuadra == null ? 43 : $faceQuadra.hashCode());
        SetorQuadra $setorQuadra = this.getSetorQuadra();
        result = result * 59 + ($setorQuadra == null ? 43 : $setorQuadra.hashCode());
        Quadricula $quadricula = this.getQuadricula();
        result = result * 59 + ($quadricula == null ? 43 : $quadricula.hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        BigDecimal $valorTerrenoIPTU = this.getValorTerrenoIPTU();
        result = result * 59 + ($valorTerrenoIPTU == null ? 43 : ((Object)$valorTerrenoIPTU).hashCode());
        BigDecimal $valorTerrenoITBI = this.getValorTerrenoITBI();
        result = result * 59 + ($valorTerrenoITBI == null ? 43 : ((Object)$valorTerrenoITBI).hashCode());
        BigDecimal $outrosValores = this.getOutrosValores();
        result = result * 59 + ($outrosValores == null ? 43 : ((Object)$outrosValores).hashCode());
        BigDecimal $larguraRua = this.getLarguraRua();
        result = result * 59 + ($larguraRua == null ? 43 : ((Object)$larguraRua).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogradouroTestadaExercicioResumoDTO(id=" + this.getId() + ", logradouroTestadaId=" + this.getLogradouroTestadaId() + ", exercicio=" + this.getExercicio() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", faceQuadra=" + this.getFaceQuadra() + ", setorQuadra=" + this.getSetorQuadra() + ", quadricula=" + this.getQuadricula() + ", logradouro=" + this.getLogradouro() + ", valorTerrenoIPTU=" + this.getValorTerrenoIPTU() + ", valorTerrenoITBI=" + this.getValorTerrenoITBI() + ", outrosValores=" + this.getOutrosValores() + ", larguraRua=" + this.getLarguraRua() + ")";
    }
}

