/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import java.util.Optional;
import lombok.Generated;

public class GeracaoDocumentoDTO {
    private String requerenteNome;
    private String requerenteCpfCnpj;
    private TipoPessoa tipoPessoaRequerente;
    private Long idProcesso;
    private Long exercicioProcesso;
    private CadastroGeral cadastroGeral;
    private Long idTipoDocumento;
    private Long idFinalidade;
    private Pessoa pessoa;
    private String observacao;
    private String usuario;
    private Boolean web = Boolean.FALSE;
    private Boolean certidaoEspecial = Boolean.FALSE;
    private Long idSequenciaItbi;

    public static GeracaoDocumentoDTO from(AlvaraLocalizacaoDTO alvaraLocalizacaoDTO, CadastroGeral cadastroGeral) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(alvaraLocalizacaoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(alvaraLocalizacaoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setCadastroGeral(cadastroGeral);
        geracaoDocumentoDTO.setIdTipoDocumento(TipoDocumentoEnum.ALVARA_LOCALIZACAO.getValue());
        Optional.ofNullable(alvaraLocalizacaoDTO.getPessoa()).ifPresent(pessoa -> {
            geracaoDocumentoDTO.setRequerenteNome(pessoa.getNome());
            geracaoDocumentoDTO.setRequerenteCpfCnpj(pessoa.getCnpjCpf());
            geracaoDocumentoDTO.setTipoPessoaRequerente(pessoa.getTipoPessoa());
        });
        return geracaoDocumentoDTO;
    }

    public static GeracaoDocumentoDTO from(DocumentoGenericoDTO documentoGenericoDTO, Pessoa pessoa, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(documentoGenericoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(documentoGenericoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setIdTipoDocumento(tipoDocumento.getValue());
        geracaoDocumentoDTO.setRequerenteNome(documentoGenericoDTO.getPessoaNome());
        geracaoDocumentoDTO.setRequerenteCpfCnpj(documentoGenericoDTO.getPessoaCpfCnpj());
        geracaoDocumentoDTO.setTipoPessoaRequerente(documentoGenericoDTO.getTipoPessoa());
        geracaoDocumentoDTO.setIdFinalidade(documentoGenericoDTO.getFinalidade());
        geracaoDocumentoDTO.setObservacao(documentoGenericoDTO.getObservacao());
        geracaoDocumentoDTO.setPessoa(pessoa);
        geracaoDocumentoDTO.setUsuario(documentoGenericoDTO.getUsuario());
        geracaoDocumentoDTO.setWeb(documentoGenericoDTO.getWeb());
        geracaoDocumentoDTO.setCertidaoEspecial(documentoGenericoDTO.getCertidaoEspecial());
        return geracaoDocumentoDTO;
    }

    public static GeracaoDocumentoDTO from(DocumentoGenericoDTO documentoGenericoDTO, CadastroGeral cadastroGeral, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = new GeracaoDocumentoDTO();
        geracaoDocumentoDTO.setIdProcesso(documentoGenericoDTO.getIdProcesso());
        geracaoDocumentoDTO.setExercicioProcesso(documentoGenericoDTO.getExercicioProcesso());
        geracaoDocumentoDTO.setIdTipoDocumento(tipoDocumento.getValue());
        geracaoDocumentoDTO.setRequerenteNome(documentoGenericoDTO.getPessoaNome());
        geracaoDocumentoDTO.setRequerenteCpfCnpj(documentoGenericoDTO.getPessoaCpfCnpj());
        geracaoDocumentoDTO.setTipoPessoaRequerente(documentoGenericoDTO.getTipoPessoa());
        geracaoDocumentoDTO.setIdFinalidade(documentoGenericoDTO.getFinalidade());
        geracaoDocumentoDTO.setObservacao(documentoGenericoDTO.getObservacao());
        geracaoDocumentoDTO.setCadastroGeral(cadastroGeral);
        geracaoDocumentoDTO.setUsuario(documentoGenericoDTO.getUsuario());
        geracaoDocumentoDTO.setWeb(documentoGenericoDTO.getWeb());
        geracaoDocumentoDTO.setCertidaoEspecial(documentoGenericoDTO.getCertidaoEspecial());
        geracaoDocumentoDTO.setIdSequenciaItbi(documentoGenericoDTO.getIdSequenciaItbi());
        return geracaoDocumentoDTO;
    }

    @Generated
    public GeracaoDocumentoDTO() {
    }

    @Generated
    public String getRequerenteNome() {
        return this.requerenteNome;
    }

    @Generated
    public String getRequerenteCpfCnpj() {
        return this.requerenteCpfCnpj;
    }

    @Generated
    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdTipoDocumento() {
        return this.idTipoDocumento;
    }

    @Generated
    public Long getIdFinalidade() {
        return this.idFinalidade;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getWeb() {
        return this.web;
    }

    @Generated
    public Boolean getCertidaoEspecial() {
        return this.certidaoEspecial;
    }

    @Generated
    public Long getIdSequenciaItbi() {
        return this.idSequenciaItbi;
    }

    @Generated
    public void setRequerenteNome(String requerenteNome) {
        this.requerenteNome = requerenteNome;
    }

    @Generated
    public void setRequerenteCpfCnpj(String requerenteCpfCnpj) {
        this.requerenteCpfCnpj = requerenteCpfCnpj;
    }

    @Generated
    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdTipoDocumento(Long idTipoDocumento) {
        this.idTipoDocumento = idTipoDocumento;
    }

    @Generated
    public void setIdFinalidade(Long idFinalidade) {
        this.idFinalidade = idFinalidade;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setWeb(Boolean web) {
        this.web = web;
    }

    @Generated
    public void setCertidaoEspecial(Boolean certidaoEspecial) {
        this.certidaoEspecial = certidaoEspecial;
    }

    @Generated
    public void setIdSequenciaItbi(Long idSequenciaItbi) {
        this.idSequenciaItbi = idSequenciaItbi;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeracaoDocumentoDTO)) {
            return false;
        }
        GeracaoDocumentoDTO other = (GeracaoDocumentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$idTipoDocumento = this.getIdTipoDocumento();
        Long other$idTipoDocumento = other.getIdTipoDocumento();
        if (this$idTipoDocumento == null ? other$idTipoDocumento != null : !((Object)this$idTipoDocumento).equals(other$idTipoDocumento)) {
            return false;
        }
        Long this$idFinalidade = this.getIdFinalidade();
        Long other$idFinalidade = other.getIdFinalidade();
        if (this$idFinalidade == null ? other$idFinalidade != null : !((Object)this$idFinalidade).equals(other$idFinalidade)) {
            return false;
        }
        Boolean this$web = this.getWeb();
        Boolean other$web = other.getWeb();
        if (this$web == null ? other$web != null : !((Object)this$web).equals(other$web)) {
            return false;
        }
        Boolean this$certidaoEspecial = this.getCertidaoEspecial();
        Boolean other$certidaoEspecial = other.getCertidaoEspecial();
        if (this$certidaoEspecial == null ? other$certidaoEspecial != null : !((Object)this$certidaoEspecial).equals(other$certidaoEspecial)) {
            return false;
        }
        Long this$idSequenciaItbi = this.getIdSequenciaItbi();
        Long other$idSequenciaItbi = other.getIdSequenciaItbi();
        if (this$idSequenciaItbi == null ? other$idSequenciaItbi != null : !((Object)this$idSequenciaItbi).equals(other$idSequenciaItbi)) {
            return false;
        }
        String this$requerenteNome = this.getRequerenteNome();
        String other$requerenteNome = other.getRequerenteNome();
        if (this$requerenteNome == null ? other$requerenteNome != null : !this$requerenteNome.equals(other$requerenteNome)) {
            return false;
        }
        String this$requerenteCpfCnpj = this.getRequerenteCpfCnpj();
        String other$requerenteCpfCnpj = other.getRequerenteCpfCnpj();
        if (this$requerenteCpfCnpj == null ? other$requerenteCpfCnpj != null : !this$requerenteCpfCnpj.equals(other$requerenteCpfCnpj)) {
            return false;
        }
        TipoPessoa this$tipoPessoaRequerente = this.getTipoPessoaRequerente();
        TipoPessoa other$tipoPessoaRequerente = other.getTipoPessoaRequerente();
        if (this$tipoPessoaRequerente == null ? other$tipoPessoaRequerente != null : !this$tipoPessoaRequerente.equals(other$tipoPessoaRequerente)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        return !(this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeracaoDocumentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $idTipoDocumento = this.getIdTipoDocumento();
        result = result * 59 + ($idTipoDocumento == null ? 43 : ((Object)$idTipoDocumento).hashCode());
        Long $idFinalidade = this.getIdFinalidade();
        result = result * 59 + ($idFinalidade == null ? 43 : ((Object)$idFinalidade).hashCode());
        Boolean $web = this.getWeb();
        result = result * 59 + ($web == null ? 43 : ((Object)$web).hashCode());
        Boolean $certidaoEspecial = this.getCertidaoEspecial();
        result = result * 59 + ($certidaoEspecial == null ? 43 : ((Object)$certidaoEspecial).hashCode());
        Long $idSequenciaItbi = this.getIdSequenciaItbi();
        result = result * 59 + ($idSequenciaItbi == null ? 43 : ((Object)$idSequenciaItbi).hashCode());
        String $requerenteNome = this.getRequerenteNome();
        result = result * 59 + ($requerenteNome == null ? 43 : $requerenteNome.hashCode());
        String $requerenteCpfCnpj = this.getRequerenteCpfCnpj();
        result = result * 59 + ($requerenteCpfCnpj == null ? 43 : $requerenteCpfCnpj.hashCode());
        TipoPessoa $tipoPessoaRequerente = this.getTipoPessoaRequerente();
        result = result * 59 + ($tipoPessoaRequerente == null ? 43 : $tipoPessoaRequerente.hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeracaoDocumentoDTO(requerenteNome=" + this.getRequerenteNome() + ", requerenteCpfCnpj=" + this.getRequerenteCpfCnpj() + ", tipoPessoaRequerente=" + this.getTipoPessoaRequerente() + ", idProcesso=" + this.getIdProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", cadastroGeral=" + this.getCadastroGeral() + ", idTipoDocumento=" + this.getIdTipoDocumento() + ", idFinalidade=" + this.getIdFinalidade() + ", pessoa=" + this.getPessoa() + ", observacao=" + this.getObservacao() + ", usuario=" + this.getUsuario() + ", web=" + this.getWeb() + ", certidaoEspecial=" + this.getCertidaoEspecial() + ", idSequenciaItbi=" + this.getIdSequenciaItbi() + ")";
    }
}

