/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.DocumentoTipoAssinatura;
import br.com.elotech.tributos.domain.DocumentoTipoAssinaturaId;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;

public class DocumentoTipoAssinaturaDTO {
    private Long tipoDocumento;
    private Long sequencia;
    @Caption(value="Data Inicial")
    @NotNull(message="Data Inicial \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Data Inicial \u00e9 obrigat\u00f3rio") LocalDate periodoInicial;
    @Caption(value="Data Final")
    private LocalDate periodoFinal;
    @Caption(value="Nome")
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio")
    @Size(max=100)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio") @Size(max=100) String nomeAssinatura;
    @Caption(value="Cargo")
    @Size(max=100)
    private @Size(max=100) String cargoAssinatura;
    @Caption(value="Fun\u00e7\u00e3o")
    @Size(max=100)
    private @Size(max=100) String funcao;
    @Caption(value="Nome Gerente")
    @Size(max=100)
    private @Size(max=100) String nomeGerente;
    @Caption(value="Cargo Gerente")
    @Size(max=100)
    private @Size(max=100) String cargoGerente;
    @Caption(value="Fun\u00e7\u00e3o Gerente")
    @Size(max=100)
    private @Size(max=100) String funcaoGerente;

    public static DocumentoTipoAssinaturaDTO from(DocumentoTipoAssinatura documentoTipoAssinatura) {
        DocumentoTipoAssinaturaDTO dto = new DocumentoTipoAssinaturaDTO();
        if (Objects.nonNull(documentoTipoAssinatura.getId())) {
            dto.setTipoDocumento(documentoTipoAssinatura.getId().getTipoDocumento());
            dto.setSequencia(documentoTipoAssinatura.getId().getSequencia());
        }
        dto.setPeriodoInicial(documentoTipoAssinatura.getPeriodoInicial());
        dto.setPeriodoFinal(documentoTipoAssinatura.getPeriodoFinal());
        dto.setNomeAssinatura(documentoTipoAssinatura.getNomeAssinatura());
        dto.setCargoAssinatura(documentoTipoAssinatura.getCargoAssinatura());
        dto.setFuncao(documentoTipoAssinatura.getFuncao());
        dto.setNomeGerente(documentoTipoAssinatura.getNomeGerente());
        dto.setCargoGerente(documentoTipoAssinatura.getCargoGerente());
        dto.setFuncaoGerente(documentoTipoAssinatura.getFuncaoGerente());
        return dto;
    }

    public static DocumentoTipoAssinatura toEntity(DocumentoTipoAssinaturaDTO dto, Long idTipoDocumento) {
        DocumentoTipoAssinaturaId id = new DocumentoTipoAssinaturaId();
        id.setTipoDocumento(idTipoDocumento);
        id.setSequencia(dto.getSequencia());
        DocumentoTipoAssinatura documentoTipoAssinatura = new DocumentoTipoAssinatura();
        documentoTipoAssinatura.setId(id);
        documentoTipoAssinatura.setPeriodoInicial(dto.getPeriodoInicial());
        documentoTipoAssinatura.setPeriodoFinal(dto.getPeriodoFinal());
        documentoTipoAssinatura.setNomeAssinatura(dto.getNomeAssinatura());
        documentoTipoAssinatura.setCargoAssinatura(dto.getCargoAssinatura());
        documentoTipoAssinatura.setFuncao(dto.getFuncao());
        documentoTipoAssinatura.setNomeGerente(dto.getNomeGerente());
        documentoTipoAssinatura.setCargoGerente(dto.getCargoGerente());
        documentoTipoAssinatura.setFuncaoGerente(dto.getFuncaoGerente());
        return documentoTipoAssinatura;
    }

    @Generated
    public DocumentoTipoAssinaturaDTO() {
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public LocalDate getPeriodoInicial() {
        return this.periodoInicial;
    }

    @Generated
    public LocalDate getPeriodoFinal() {
        return this.periodoFinal;
    }

    @Generated
    public String getNomeAssinatura() {
        return this.nomeAssinatura;
    }

    @Generated
    public String getCargoAssinatura() {
        return this.cargoAssinatura;
    }

    @Generated
    public String getFuncao() {
        return this.funcao;
    }

    @Generated
    public String getNomeGerente() {
        return this.nomeGerente;
    }

    @Generated
    public String getCargoGerente() {
        return this.cargoGerente;
    }

    @Generated
    public String getFuncaoGerente() {
        return this.funcaoGerente;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setPeriodoInicial(LocalDate periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Generated
    public void setPeriodoFinal(LocalDate periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @Generated
    public void setNomeAssinatura(String nomeAssinatura) {
        this.nomeAssinatura = nomeAssinatura;
    }

    @Generated
    public void setCargoAssinatura(String cargoAssinatura) {
        this.cargoAssinatura = cargoAssinatura;
    }

    @Generated
    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    @Generated
    public void setNomeGerente(String nomeGerente) {
        this.nomeGerente = nomeGerente;
    }

    @Generated
    public void setCargoGerente(String cargoGerente) {
        this.cargoGerente = cargoGerente;
    }

    @Generated
    public void setFuncaoGerente(String funcaoGerente) {
        this.funcaoGerente = funcaoGerente;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoTipoAssinaturaDTO)) {
            return false;
        }
        DocumentoTipoAssinaturaDTO other = (DocumentoTipoAssinaturaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        LocalDate this$periodoInicial = this.getPeriodoInicial();
        LocalDate other$periodoInicial = other.getPeriodoInicial();
        if (this$periodoInicial == null ? other$periodoInicial != null : !((Object)this$periodoInicial).equals(other$periodoInicial)) {
            return false;
        }
        LocalDate this$periodoFinal = this.getPeriodoFinal();
        LocalDate other$periodoFinal = other.getPeriodoFinal();
        if (this$periodoFinal == null ? other$periodoFinal != null : !((Object)this$periodoFinal).equals(other$periodoFinal)) {
            return false;
        }
        String this$nomeAssinatura = this.getNomeAssinatura();
        String other$nomeAssinatura = other.getNomeAssinatura();
        if (this$nomeAssinatura == null ? other$nomeAssinatura != null : !this$nomeAssinatura.equals(other$nomeAssinatura)) {
            return false;
        }
        String this$cargoAssinatura = this.getCargoAssinatura();
        String other$cargoAssinatura = other.getCargoAssinatura();
        if (this$cargoAssinatura == null ? other$cargoAssinatura != null : !this$cargoAssinatura.equals(other$cargoAssinatura)) {
            return false;
        }
        String this$funcao = this.getFuncao();
        String other$funcao = other.getFuncao();
        if (this$funcao == null ? other$funcao != null : !this$funcao.equals(other$funcao)) {
            return false;
        }
        String this$nomeGerente = this.getNomeGerente();
        String other$nomeGerente = other.getNomeGerente();
        if (this$nomeGerente == null ? other$nomeGerente != null : !this$nomeGerente.equals(other$nomeGerente)) {
            return false;
        }
        String this$cargoGerente = this.getCargoGerente();
        String other$cargoGerente = other.getCargoGerente();
        if (this$cargoGerente == null ? other$cargoGerente != null : !this$cargoGerente.equals(other$cargoGerente)) {
            return false;
        }
        String this$funcaoGerente = this.getFuncaoGerente();
        String other$funcaoGerente = other.getFuncaoGerente();
        return !(this$funcaoGerente == null ? other$funcaoGerente != null : !this$funcaoGerente.equals(other$funcaoGerente));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoTipoAssinaturaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        LocalDate $periodoInicial = this.getPeriodoInicial();
        result = result * 59 + ($periodoInicial == null ? 43 : ((Object)$periodoInicial).hashCode());
        LocalDate $periodoFinal = this.getPeriodoFinal();
        result = result * 59 + ($periodoFinal == null ? 43 : ((Object)$periodoFinal).hashCode());
        String $nomeAssinatura = this.getNomeAssinatura();
        result = result * 59 + ($nomeAssinatura == null ? 43 : $nomeAssinatura.hashCode());
        String $cargoAssinatura = this.getCargoAssinatura();
        result = result * 59 + ($cargoAssinatura == null ? 43 : $cargoAssinatura.hashCode());
        String $funcao = this.getFuncao();
        result = result * 59 + ($funcao == null ? 43 : $funcao.hashCode());
        String $nomeGerente = this.getNomeGerente();
        result = result * 59 + ($nomeGerente == null ? 43 : $nomeGerente.hashCode());
        String $cargoGerente = this.getCargoGerente();
        result = result * 59 + ($cargoGerente == null ? 43 : $cargoGerente.hashCode());
        String $funcaoGerente = this.getFuncaoGerente();
        result = result * 59 + ($funcaoGerente == null ? 43 : $funcaoGerente.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoTipoAssinaturaDTO(tipoDocumento=" + this.getTipoDocumento() + ", sequencia=" + this.getSequencia() + ", periodoInicial=" + this.getPeriodoInicial() + ", periodoFinal=" + this.getPeriodoFinal() + ", nomeAssinatura=" + this.getNomeAssinatura() + ", cargoAssinatura=" + this.getCargoAssinatura() + ", funcao=" + this.getFuncao() + ", nomeGerente=" + this.getNomeGerente() + ", cargoGerente=" + this.getCargoGerente() + ", funcaoGerente=" + this.getFuncaoGerente() + ")";
    }
}

