/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoLinha;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.domain.TipoCalculo;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CalculoCadastroResumidoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResumoDTO;
import br.com.elotech.tributos.calculo.dto.SimulacaoCalculoDTO;
import br.com.elotech.tributos.calculo.repository.CalculoCadastroRepository;
import br.com.elotech.tributos.calculo.repository.CalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.CalculoTributoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CalculoFormaPagamentoDTO;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.JoinType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CalculoService
extends CrudService<Calculo, Long> {
    private final CalculoRepository calculoRepository;
    private final CalculoTributoExecucaoService calculoTributoExecucaoService;
    private final CalculoTributoService calculoTributoService;
    private final CalculoCadastroRepository calculoCadastroRepository;
    private final DividaService dividaService;
    private final GeraDebitoService geraDebitoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final CalculoCadastroService calculoCadastroService;
    private final CalculoLoteImpressaoService calculoLoteImpressaoService;
    private final RespostaRepository respostaRepository;
    private final ConversionService conversionService;
    private final TabelaValorService tabelaValorService;

    public Calculo createSimulacao(SimulacaoCalculoDTO simulacaoCalculoDTO) {
        List dividas = this.findDividasByExercicioAndTipoDivida(simulacaoCalculoDTO.getAno(), simulacaoCalculoDTO.getTipoDivida());
        List dividasFiltradas = simulacaoCalculoDTO.getDividas().stream().map(idDivida -> dividas.stream().filter(divida -> divida.getId().equals(idDivida)).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u0101o foram encontradas f\u00f3rmulas para calcular os tributos da d\u00edvida %d no exerc\u00edcio de %d.", idDivida, simulacaoCalculoDTO.getAno())))).collect(Collectors.toList());
        Calculo calculo = simulacaoCalculoDTO.toEntity(dividasFiltradas);
        calculo.setUsuario(SecurityUtils.getUserAise());
        calculo.setDataCalculo(LocalDate.now());
        calculo.setSituacao(SituacaoCalculo.GERANDO_SIMULACAO);
        calculo.setTipo(simulacaoCalculoDTO.getTipo());
        this.calculoTributoExecucaoService.verifyFiltroTemUmCadastroGeralPeloMenos(calculo.buildFilterCadastros());
        this.save((EloEntity)calculo, null);
        return calculo;
    }

    public CalculoTabelaValores loadCalculoTabelaValores(Long exercicio) {
        return new CalculoTabelaValores(this.conversionService, this.tabelaValorService.findByExercicio(exercicio));
    }

    public List<CalculoCadastro> calcularByCadastroSemCompilarFormulas(Calculo calculo, List<CalculoTributo> tributos, Long idCadastroGeral, String parametroIsencaoValorMinimo, CalculoTabelaValores calculoTabelaValores) {
        List result = this.calculoTributoExecucaoService.calcularSemCompilarFormulas(tributos, calculo.getExercicio(), calculo.buildFilterCadastrosById(String.format("%d", idCadastroGeral)), calculo.getDataLancamento(), calculoTabelaValores);
        if (result.isEmpty()) {
            throw new EloValidationException(String.format("Falha ao calcular cadastro geral com ID %d.", idCadastroGeral));
        }
        List calculoCadastros = calculo.parseResultados(result);
        calculoCadastros.forEach(calculoCadastro -> {
            calculoCadastro.validateValorMinimoDebitoAndParcela(parametroIsencaoValorMinimo);
            this.validateTabelaValoresAndGrupoVencimento(calculoCadastro, calculoTabelaValores);
        });
        return calculoCadastros;
    }

    private void validateTabelaValoresAndGrupoVencimento(CalculoCadastro calculoCadastro, CalculoTabelaValores calculoTabelaValores) {
        if (Objects.isNull(calculoCadastro.getDivida().getTabelaValor())) {
            return;
        }
        Long grupoVencimento = calculoTabelaValores.calculaTabelaValores(calculoCadastro.getDivida().getTabelaValor().getNome(), new Object[]{calculoCadastro.getValorTotal()}).longValue();
        calculoCadastro.validateIdentificadorGrupoVencimento(grupoVencimento);
    }

    public void updateSituacaoSimulacaoGeradaSeTodosCadastrosCalculados(Long idCalculo) {
        Calculo calculo = this.findCalculoById(idCalculo);
        if (calculo.getCadastros().stream().allMatch(CalculoCadastro::calculou)) {
            calculo.setSituacao(SituacaoCalculo.SIMULACAO_GERADA);
            this.save((EloEntity)calculo, null);
        }
    }

    public void updateSituacaoCalculo(Long idCalculo, SituacaoCalculo situacaoCalculo) {
        Calculo calculo = this.findCalculoById(idCalculo);
        calculo.setSituacao(situacaoCalculo);
        this.save((EloEntity)calculo, null);
    }

    private List<Divida> findDividasByExercicioAndTipoDivida(Long exercicio, TipoDivida tipoDivida) {
        List dividas = this.dividaService.findByExercicioAndTipoDividaAndWithScriptCalculo(exercicio, tipoDivida);
        if (dividas.isEmpty()) {
            throw new EloValidationException(String.format("N\u0101o foram encontradas d\u00edvidas para o tipoDivida \"%s\" informado no exerc\u00edcio de %d com f\u00f3rmulas de c\u00e1lculo configuradas.", tipoDivida.getDescricao(), exercicio));
        }
        return dividas;
    }

    private List<CalculoTributo> findFormulas(List<Divida> dividas, Long exercicio) {
        List tributos = this.calculoTributoService.findByDividasAndExercicio(dividas, exercicio);
        if (tributos.isEmpty()) {
            String ids = dividas.stream().map(divida -> divida.getDivida().toString()).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("N\u0101o foram encontradas f\u00f3rmulas para calcular os tributos da(s) d\u00edvida(s) %s no exerc\u00edcio de %d.", ids, exercicio));
        }
        return tributos;
    }

    private String findParametroIsencaoValorMinimo(Long exercicio) {
        ParametroEntidadeExercicio parametroIsencaoValorMinimo = this.parametroEntidadeExercicioService.findByExercicioAndModuloAndParametro(exercicio, ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue());
        if (Objects.isNull(parametroIsencaoValorMinimo)) {
            return null;
        }
        return parametroIsencaoValorMinimo.getValor();
    }

    private void throwExceptionIfCalculoNaoTemSituacaoGerada(SituacaoCalculo situacaoCalculo, String exceptionMessage) {
        if (!SituacaoCalculo.SIMULACAO_GERADA.equals((Object)situacaoCalculo)) {
            throw new EloValidationException(exceptionMessage);
        }
    }

    public Page<CalculoCadastroResumidoDTO> findCadastrosWithPagination(Long id, String search, Boolean somenteInconsistentes, Pageable pageable) {
        String idClause = String.format("calculo.id==%d", id);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), CalculoCadastro.class, (String)searchWithIdClause);
        if (Boolean.TRUE.equals(somenteInconsistentes)) {
            Specification & Serializable inconsistentesSpecification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
                root.join("inconsistencias", JoinType.INNER);
                return criteriaBuilder.conjunction();
            };
            specification = specification.and((Specification)inconsistentesSpecification);
        }
        return this.calculoCadastroRepository.findAll(specification, pageable).map(CalculoCadastroResumidoDTO::from);
    }

    public CalculoCadastro recalcularCadastro(Long idCalculo, Long idCalculoCadastro) {
        Calculo calculo = this.findCalculoById(idCalculo);
        CalculoCadastro calculoCadastro = (CalculoCadastro)this.calculoCadastroService.findById((Serializable)idCalculoCadastro).orElseThrow(() -> new EloValidationException(String.format("C\u00e1lculo cadastro %d n\u00e3o encontrado.", idCalculoCadastro)));
        return this.recalcularCadastro(calculo, calculoCadastro);
    }

    private CalculoCadastro recalcularCadastro(Calculo calculo, CalculoCadastro calculoCadastro) {
        this.throwExceptionIfCalculoNaoTemSituacaoGerada(calculo.getSituacao(), String.format("C\u00e1lculo com situa\u00e7\u00e3o %s n\u00e3o permite rec\u00e1lculo.", calculo.getSituacao().getDescricao()));
        List<Divida> dividas = Collections.singletonList(calculoCadastro.getDivida());
        List tributos = this.findFormulas(dividas, calculo.getExercicio());
        List result = this.calculoTributoExecucaoService.calcular(tributos, calculo.getExercicio(), calculo.buildFilterCadastrosById(String.format("%d", calculoCadastro.getCadastro().getId())), Boolean.valueOf(calculo.getTipo().equals((Object)TipoCalculo.SIMPLES)), calculo.getDataLancamento());
        if (result.isEmpty()) {
            throw new EloValidationException(String.format("Falha ao recalcular cadastro %d/%d.", calculoCadastro.getCadastro().getTipoCadastro().getValue(), calculoCadastro.getCadastro().getCadastroGeral()));
        }
        String parametroIsencaoValorMinimo = this.findParametroIsencaoValorMinimo(calculo.getExercicio());
        calculoCadastro.recalcularResultado((CadastroCalculoRoot)result.get(0));
        calculoCadastro.validateValorMinimoDebitoAndParcela(parametroIsencaoValorMinimo);
        return (CalculoCadastro)this.calculoCadastroService.save((EloEntity)calculoCadastro, null);
    }

    public List<CalculoCadastro> recalcularAllCadastrosInconsistentes(Long id) {
        Calculo calculo = this.findCalculoById(id);
        List cadastrosInconsistentes = this.calculoCadastroService.findInconsistentesByCalculo(id);
        return cadastrosInconsistentes.stream().map(calculoCadastro -> this.recalcularCadastro(calculo, calculoCadastro)).collect(Collectors.toList());
    }

    public Calculo cancelarSimulacao(Long id) {
        Calculo calculo = this.findCalculoById(id);
        SituacaoCalculo situacaoCalculo = calculo.getSituacao();
        if (SituacaoCalculo.SIMULACAO_CANCELADA.equals((Object)situacaoCalculo)) {
            throw new EloValidationException(String.format("A simula\u00e7\u00e3o com ID %d j\u00e1 est\u00e1 cancelada.", calculo.getId()));
        }
        if (!SituacaoCalculo.SIMULACAO_GERADA.equals((Object)calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido cancelar a simula\u00e7\u00e3o com uma situa\u00e7\u00e3o de c\u00e1lculo diferente de \"%s\".", SituacaoCalculo.SIMULACAO_GERADA.getDescricao()));
        }
        calculo.setUsuarioCancelamento(SecurityUtils.getUserAise());
        calculo.setDataCancelamento(LocalDate.now());
        calculo.setSituacao(SituacaoCalculo.SIMULACAO_CANCELADA);
        this.save((EloEntity)calculo, null);
        return calculo;
    }

    public Calculo findCalculoById(Long id) {
        return (Calculo)this.calculoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("C\u00e1lculo %d n\u00e3o encontrado.", id)));
    }

    public CalculoResumoDTO findCalculoByIdWithTotais(Long id) {
        Calculo calculo = (Calculo)this.calculoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("C\u00e1lculo %d n\u00e3o encontrado.", id)));
        BigDecimal totalCalculado = this.calculoCadastroRepository.getTotalCalculadoByCalculo(id);
        BigDecimal totalIsencoes = this.calculoCadastroRepository.getTotalIsencoesByCalculo(id);
        return CalculoResumoDTO.of((Calculo)calculo, (BigDecimal)totalCalculado, (BigDecimal)totalIsencoes);
    }

    public Calculo updateCalculoParaGerarDebitos(Long id) {
        Calculo calculo = this.findCalculoById(id);
        if (!SituacaoCalculo.SIMULACAO_GERADA.equals((Object)calculo.getSituacao()) && !SituacaoCalculo.ERRO_GERACAO_DEBITO.equals((Object)calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar d\u00e9bito para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
        }
        if (calculo.getCadastros().stream().allMatch(CalculoCadastro::hasInconsistencia)) {
            throw new EloValidationException("Todos cadastros est\u00e3o inconsistentes, n\u00e3o \u00e9 poss\u00edvel gerar d\u00e9bito para cadastros nesta situa\u00e7\u00e3o.");
        }
        calculo.setSituacao(SituacaoCalculo.GERANDO_DEBITO);
        this.calculoRepository.save((Object)calculo);
        return calculo;
    }

    public CalculoCadastro gerarDebitoCadastroConsistente(CalculoCadastro calculoCadastro, Long entidade, CalculoTabelaValores calculoTabelaValores) {
        Debito debito = this.geraDebitoService.generateDebitoCalculo(calculoCadastro, entidade, calculoTabelaValores);
        calculoCadastro.setDebito(debito);
        return calculoCadastro;
    }

    public void salvarCamposDinamicosCalculo(CalculoCadastro calculoCadastro) {
        calculoCadastro.getResultados().forEach(calculoResultado -> {
            List linhasComCampoDinamicoPreenchido = calculoResultado.getLinhas().stream().filter(calculoLinha -> Objects.nonNull(calculoLinha.getCampoDinamico())).collect(Collectors.toList());
            if (!TipoCalculoConfig.SEGMENTO.equals((Object)calculoResultado.getCalculoTributo().getTipo())) {
                linhasComCampoDinamicoPreenchido.stream().filter(calculoLinha -> !FuncionalidadeCampo.SEGMENTO.equals((Object)calculoLinha.getCampoDinamico().getGrupoCampo().getFuncionalidade())).collect(Collectors.groupingBy(CalculoLinha::getCampoDinamico, Collectors.reducing((accum, element) -> {
                    accum.setValor(accum.getValor().add(element.getValor()));
                    return accum;
                }))).forEach((campo, calculoLinha) -> {
                    BigDecimal valor = calculoLinha.map(CalculoLinha::getValor).orElse(BigDecimal.ZERO);
                    this.atualizaResposta(calculoCadastro.getCadastro(), null, campo, valor);
                });
            } else {
                linhasComCampoDinamicoPreenchido.stream().filter(calculoLinha -> FuncionalidadeCampo.SEGMENTO.equals((Object)calculoLinha.getCampoDinamico().getGrupoCampo().getFuncionalidade())).collect(Collectors.groupingBy(CalculoLinha::getIdSegmento, Collectors.groupingBy(CalculoLinha::getCampoDinamico, Collectors.reducing((accum, element) -> {
                    accum.setValor(accum.getValor().add(element.getValor()));
                    return accum;
                })))).forEach((idSegmento, campoOptionalMap) -> campoOptionalMap.forEach((key, value) -> {
                    BigDecimal valor = value.map(CalculoLinha::getValor).orElse(BigDecimal.ZERO);
                    this.atualizaResposta(calculoCadastro.getCadastro(), idSegmento, key, valor);
                }));
            }
        });
    }

    private void atualizaResposta(CadastroGeral cadastroGeral, Long idSegmento, Campo campoDinamico, BigDecimal valor) {
        Resposta resposta = null;
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$camposdinamicos$FuncionalidadeCampo[campoDinamico.getGrupoCampo().getFuncionalidade().ordinal()]) {
            case 1: {
                resposta = (Resposta)this.respostaRepository.getRespostasSegmentoFiterByCampo(idSegmento, campoDinamico.getId()).stream().findFirst().orElse(new RespostaSegmento());
                CadastroImobiliarioSegmento segmento = (CadastroImobiliarioSegmento)this.getEm().getReference(CadastroImobiliarioSegmento.class, (Object)idSegmento);
                ((RespostaSegmento)resposta).setSegmento(segmento);
                break;
            }
            case 2: {
                resposta = (Resposta)this.respostaRepository.getRespostasTerrenoFilterByCampo(cadastroGeral.getId(), campoDinamico.getId()).stream().findFirst().orElse(new RespostaTerreno());
                CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.getEm().getReference(CadastroImobiliario.class, (Object)cadastroGeral.getId());
                ((RespostaTerreno)resposta).setCadastroImobiliario(cadastroImobiliario);
                break;
            }
            case 3: {
                resposta = (Resposta)this.respostaRepository.getRespostasMobiliarioFilterByCampo(cadastroGeral.getId(), campoDinamico.getId()).stream().findFirst().orElse(new RespostaMobiliario());
                CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.getEm().getReference(CadastroMobiliario.class, (Object)cadastroGeral.getId());
                ((RespostaMobiliario)resposta).setCadastroMobiliario(cadastroMobiliario);
                break;
            }
            default: {
                throw new EloValidationException("Tipo de campo din\u00e2mico n\u00e3o implementado para resultado de c\u00e1lculo");
            }
        }
        resposta.setCampo(campoDinamico);
        resposta.setValor(new DecimalFormat("#0.##").format(valor).replaceAll(",", "."));
        this.respostaRepository.save((Object)resposta);
    }

    public void updateSituacaoDebitoGeradoSeTodosCadastrosConsistentesComDebito(Long idCalculo) {
        Calculo calculo = this.findCalculoById(idCalculo);
        if (calculo.getCadastros().stream().noneMatch(calculoCadastro -> calculoCadastro.hasInconsistencia() == false && Objects.isNull(calculoCadastro.getDebito()))) {
            calculo.setSituacao(SituacaoCalculo.DEBITO_GERADO);
            calculo.setUsuarioGeracaoDebito(SecurityUtils.getUserAise());
            calculo.setDataGeracaoDebito(LocalDate.now());
            this.save((EloEntity)calculo, null);
            if (TipoCalculo.SIMPLES.equals((Object)calculo.getTipo())) {
                this.constituirDebitos(idCalculo);
            }
        }
    }

    public CalculoResumoDTO finalizarGeracaoLoteImpressao(Long id) {
        Calculo calculo = this.findCalculoById(id);
        if (SituacaoCalculo.DEBITO_GERADO.equals((Object)calculo.getSituacao())) {
            if (this.calculoLoteImpressaoService.findbyCalculoId(id, "", Pageable.unpaged()).isEmpty()) {
                throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel finalizar gera\u00e7\u00e3o de lotes de impress\u00e3o caso n\u00e3o tenha sido gerado nenhum lote.");
            }
            calculo.setSituacao(SituacaoCalculo.LOTE_GERADO);
            return CalculoResumoDTO.of((Calculo)((Calculo)this.calculoRepository.save((Object)calculo)));
        }
        throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel finalizar gera\u00e7\u00e3o de lotes de impress\u00e3o para c\u00e1lculo com situa\u00e7\u00e3o %s", calculo.getSituacao().getDescricao()));
    }

    public List<CalculoFormaPagamentoDTO> findFormasPagamentosDisponiveis(Long id) {
        return this.findFormasPagamentosDisponiveis(this.findCalculoById(id));
    }

    private List<CalculoFormaPagamentoDTO> findFormasPagamentosDisponiveis(Calculo calculo) {
        return calculo.getDividas().stream().map(Divida::getFormasPagamento).flatMap(Collection::stream).map(CalculoFormaPagamentoDTO::of).filter(formaPagamento -> !TipoFormaPagamento.RESTANTE.equals((Object)formaPagamento.getTipoFormaPagamento()) && Objects.nonNull(formaPagamento.getVencimento()) && !LocalDate.now().isAfter(formaPagamento.getVencimento())).sorted(Comparator.comparing(CalculoFormaPagamentoDTO::getDivida).thenComparing(CalculoFormaPagamentoDTO::getFormaPagamento)).collect(Collectors.toList());
    }

    public void saveFormasPagamento(Long id, List<CalculoFormaPagamentoDTO> formasPagamento) {
        Calculo calculo = this.findCalculoById(id);
        List formasPagamentoDisponiveis = this.findFormasPagamentosDisponiveis(calculo);
        if (!formasPagamentoDisponiveis.containsAll(formasPagamento)) {
            throw new EloValidationException(String.format("As seguintes formas de pagamento n\u00e3o est\u00e3o disponive\u00eds para esse c\u00e1lculo: %s.", formasPagamento.stream().filter(formaPagamento -> !formasPagamentoDisponiveis.contains(formaPagamento)).map(formaPagamento -> String.format("\"%d - %s\" (\"%d - %s\")", formaPagamento.getFormaPagamento(), formaPagamento.getDescricaoFormaPagamento(), formaPagamento.getDivida(), formaPagamento.getDescricaoDivida())).collect(Collectors.joining(", "))));
        }
        this.validaDividas(calculo.getDividas(), formasPagamento);
        calculo.replaceAllCalculoFormaPagamento(formasPagamento);
        this.calculoRepository.save((Object)calculo);
    }

    private void validaDividas(List<Divida> dividas, List<CalculoFormaPagamentoDTO> formasPagamento) {
        List dividasNaoConfiguradas = dividas.stream().filter(divida -> formasPagamento.stream().noneMatch(formaPagamento -> formaPagamento.getDivida().equals(divida.getDivida()))).collect(Collectors.toList());
        if (!dividasNaoConfiguradas.isEmpty()) {
            throw new EloValidationException(String.format("Necess\u00e1rio configurar pelo menos uma forma de pagamento para cada d\u00edvida do c\u00e1lculo. Falta configurar as seguintes d\u00edvidas: %s.", dividasNaoConfiguradas.stream().map(divida -> String.format("\"%d - %s\"", divida.getDivida(), divida.getDescricao())).collect(Collectors.joining(", "))));
        }
    }

    public void constituirDebitos(Long idCalculo) {
        Calculo calculo = this.findCalculoById(idCalculo);
        if (!(SituacaoCalculo.CARNE_GERADO.equals((Object)calculo.getSituacao()) || SituacaoCalculo.ARQUIVO_GERADO.equals((Object)calculo.getSituacao()) || TipoCalculo.SIMPLES.equals((Object)calculo.getTipo()))) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel constituir d\u00e9bitos com a situa\u00e7\u00e3o de c\u00e1lculo \"%s\".", calculo.getSituacao().getDescricao()));
        }
        if (Boolean.TRUE.equals(calculo.getConstituido())) {
            throw new EloValidationException(String.format("O c\u00e1lculo %d j\u00e1 est\u00e1 com os d\u00e9bitos constitu\u00eddos.", calculo.getId()));
        }
        this.geraDebitoService.constituirDebitosCalculo(calculo.getId());
        calculo.setConstituido(Boolean.TRUE);
        this.save((EloEntity)calculo, null);
    }

    public Calculo prepareSimularNovamente(Long idCalculo) {
        Calculo calculo = this.findCalculoById(idCalculo);
        this.throwExceptionIfCalculoNaoTemSituacaoGerada(calculo.getSituacao(), String.format("N\u00e3o \u00e9 permitido simular novamente com uma situa\u00e7\u00e3o de c\u00e1lculo diferente de \"%s\".", SituacaoCalculo.SIMULACAO_GERADA.getDescricao()));
        this.calculoRepository.removeVinculoCalculoCadastro(idCalculo);
        return calculo;
    }

    @Generated
    public CalculoService(CalculoRepository calculoRepository, CalculoTributoExecucaoService calculoTributoExecucaoService, CalculoTributoService calculoTributoService, CalculoCadastroRepository calculoCadastroRepository, DividaService dividaService, GeraDebitoService geraDebitoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, CalculoCadastroService calculoCadastroService, CalculoLoteImpressaoService calculoLoteImpressaoService, RespostaRepository respostaRepository, ConversionService conversionService, TabelaValorService tabelaValorService) {
        this.calculoRepository = calculoRepository;
        this.calculoTributoExecucaoService = calculoTributoExecucaoService;
        this.calculoTributoService = calculoTributoService;
        this.calculoCadastroRepository = calculoCadastroRepository;
        this.dividaService = dividaService;
        this.geraDebitoService = geraDebitoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.calculoCadastroService = calculoCadastroService;
        this.calculoLoteImpressaoService = calculoLoteImpressaoService;
        this.respostaRepository = respostaRepository;
        this.conversionService = conversionService;
        this.tabelaValorService = tabelaValorService;
    }
}

