/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoCalculoBatchWriter
implements ItemWriter<List<CalculoCadastro>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulacaoCalculoBatchWriter.class);
    private final CalculoService calculoService;
    private final CalculoCadastroService calculoCadastroService;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    public SimulacaoCalculoBatchWriter(CalculoService calculoService, CalculoCadastroService calculoCadastroService, EntityManager entityManager) {
        this.calculoService = calculoService;
        this.calculoCadastroService = calculoCadastroService;
        this.entityManager = entityManager;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends List<CalculoCadastro>> items) {
        LOGGER.info("Salvando os cadastros calculados. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        items.forEach(arg_0 -> ((CalculoCadastroService)this.calculoCadastroService).saveAll(arg_0));
        this.entityManager.flush();
    }
}

