/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.RestituicaoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.RetencaoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.TipoLancamentoCredito;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoTributoRepository;
import br.com.elotech.tributos.repository.simam.RestituicaoLancamentoCreditoRepository;
import br.com.elotech.tributos.repository.simam.RetencaoLancamentoCreditoRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class LancamentoCreditoBatchWriter
implements ItemWriter<TipoLancamentoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LancamentoCreditoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final LancamentoCreditoTributoRepository lancamentoCreditoTributoRepository;
    private final RetencaoLancamentoCreditoRepository retencaoLancamentoCreditoRepository;
    private final RestituicaoLancamentoCreditoRepository restituicaoLancamentoCreditoRepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoLancamentoCredito> items) {
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoLancamentoCredito> items) {
        List lancamentoCreditoTributos = items.stream().filter(LancamentoCreditoTributo.class::isInstance).map(LancamentoCreditoTributo.class::cast).collect(Collectors.toList());
        List retencaoLancamentoCreditos = items.stream().filter(RetencaoLancamentoCredito.class::isInstance).map(RetencaoLancamentoCredito.class::cast).collect(Collectors.toList());
        List restituicaoLancamentoCreditos = items.stream().filter(RestituicaoLancamentoCredito.class::isInstance).map(RestituicaoLancamentoCredito.class::cast).collect(Collectors.toList());
        this.lancamentoCreditoTributoRepository.saveAll(lancamentoCreditoTributos);
        this.retencaoLancamentoCreditoRepository.saveAll(retencaoLancamentoCreditos);
        this.restituicaoLancamentoCreditoRepository.saveAll(restituicaoLancamentoCreditos);
        this.entityManager.flush();
    }

    @Generated
    public LancamentoCreditoBatchWriter(EntityManager entityManager, LancamentoCreditoTributoRepository lancamentoCreditoTributoRepository, RetencaoLancamentoCreditoRepository retencaoLancamentoCreditoRepository, RestituicaoLancamentoCreditoRepository restituicaoLancamentoCreditoRepository) {
        this.entityManager = entityManager;
        this.lancamentoCreditoTributoRepository = lancamentoCreditoTributoRepository;
        this.retencaoLancamentoCreditoRepository = retencaoLancamentoCreditoRepository;
        this.restituicaoLancamentoCreditoRepository = restituicaoLancamentoCreditoRepository;
    }
}

