/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.atualizacaomonetariada;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.simam.AtualizacaoDividaAtivaService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class AtualizacaoMonetariaCreditoDAJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoMonetariaCreditoDAJobListener.class);
    private static String PREFIXO = "SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String ATUALIZACAO_CREDITO = JobType.SIMAM_ATUALIZACAO_MONETARIA_CREDITO_DA.getTipo();
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final AtualizacaoDividaAtivaService atualizacaoDividaAtivaService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Optional notificacaoId = this.notificacaoService.send(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - %s -> %s", dataInicial.toString(), dataFinal.toString()), PREFIXO + "iniciado", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Os dados referentes a Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial.toString(), dataFinal.toString()), PREFIXO + "finalizado com sucesso", jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("N\u00e3o foi poss\u00edvel gerar os dados.", "Erro na gera\u00e7\u00e3o de dados do SIM-AM - Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public AtualizacaoMonetariaCreditoDAJobListener(NotificacaoService notificacaoService, AtualizacaoDividaAtivaService atualizacaoDividaAtivaService) {
        this.notificacaoService = notificacaoService;
        this.atualizacaoDividaAtivaService = atualizacaoDividaAtivaService;
    }
}

