/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.geracaocda;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoDebito;
import br.com.elotech.tributos.domain.ComunicadoDebitoId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.ComunicadoLoteGeracaoCdaDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemDetalheRepository;
import br.com.elotech.tributos.service.ComunicadoCadastroService;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoGeracaoCdaBatchProcessor
implements ItemProcessor<ComunicadoLoteGeracaoCdaDTO, ComunicadoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoGeracaoCdaBatchProcessor.class);
    private static final String LOG_PARAM = "COMUNICADO - A partir de Lote de CDA - ";
    protected StepExecution stepExecution;
    private AtomicLong sequencia;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final LoteCdaItemDetalheRepository loteCdaItemDetalheRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        this.sequencia = this.comunicadoCadastroService.findNextSequencia(entidade, exercicioComunicado, idComunicadoParam);
        LOGGER.info("COMUNICADO - A partir de Lote de CDA - Iniciando gera\u00e7\u00e3o de dados");
    }

    public ComunicadoCadastro process(ComunicadoLoteGeracaoCdaDTO item) throws Exception {
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setIdComunicado(idComunicadoParam);
        idComunicado.setEntidade(entidade);
        idComunicado.setExercicio(exercicioComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        ComunicadoCadastroId idComunicadoCadastro = new ComunicadoCadastroId();
        idComunicadoCadastro.setComunicado(comunicado);
        idComunicadoCadastro.setSequencia(Long.valueOf(this.sequencia.getAndIncrement()));
        ComunicadoCadastro comunicadoCadastro = new ComunicadoCadastro();
        comunicadoCadastro.setId(idComunicadoCadastro);
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO.getDescricao());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(item.getIdPessoa());
        comunicadoCadastro.setPessoa(pessoa);
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(item.getIdCadastroGeral());
        cadastroGeral.setTipoCadastro(item.getTipoCadastro());
        cadastroGeral.setCadastroGeral(item.getCadastroGeral());
        comunicadoCadastro.setCadastroGeral(cadastroGeral);
        this.loteCdaItemDetalheRepository.findAllByLoteCdaItem(item.getIdLoteItem()).forEach(itemDetalhe -> {
            ComunicadoDebitoId comunicadoDebitoId = new ComunicadoDebitoId();
            comunicadoDebitoId.setComunicadoCadastro(comunicadoCadastro);
            comunicadoDebitoId.setIdDebitoParcelaReceita(itemDetalhe.getParcelaTributo().getId());
            ComunicadoDebito comunicadoDebito = new ComunicadoDebito();
            comunicadoDebito.setId(comunicadoDebitoId);
            comunicadoDebito.setValorCorrecao(itemDetalhe.getValorCorrecao());
            comunicadoDebito.setValorMulta(itemDetalhe.getValorMulta());
            comunicadoDebito.setValorJuros(itemDetalhe.getValorJuros());
            comunicadoDebito.setValorPrincipal(itemDetalhe.getValor());
            comunicadoCadastro.getComunicadoDebitos().add(comunicadoDebito);
        });
        return comunicadoCadastro;
    }

    @Generated
    public ComunicadoGeracaoCdaBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, LoteCdaItemDetalheRepository loteCdaItemDetalheRepository) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.loteCdaItemDetalheRepository = loteCdaItemDetalheRepository;
    }
}

