select filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idCancelamento,
       filtro.entidade,
       filtro.exercicio,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.iddebitoparcelareceita,
       filtro.idParcelamento
from
    (
        select md.idato,
               tc.nrdeducao as nrDeducao,
               tc.nranodeducao as nrAnoDeducao,
               tcdi.dataestorno as dtEstorno,
               tcdi.valor as vlEstorno,
               substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
               cd.idcancelamento,
               cd.entidade,
               cd.exercicio,
               0 as idpagamentobloqueto,
               0 as idcreditocontribuinteitem,
               tcdi.iddebitoparcelareceita,
               0 as idParcelamento
        from tribcancelamentodebito            cd
                 join tribcancelamentodebitoitem   tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento
                 left join tceDeducaoCancelamento       tdc  on tdc.entidade = tcdi.entidade and tdc.exercicio = tcdi.exercicio
            and tdc.idcancelamento = tcdi.idcancelamento and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                 left join tceDeducaoCredito            tc   on tc.idtcededucaocredito = tdc.idtcededucaocredito
                 left join tribmotivodesconto           md   on md.motivodesconto  = cd.motivocancelamento
                 join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                 left join tribreceita                  tr   on tr.entidade = :entidade
            and tr.exercicio = :exercicio
            and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
        where cd.entidade = :entidade
          and tcdi.dataestorno between :dataInicial and :dataFinal
          and tcdi.estornado = 'S'
          and cd.tipoDeducao <> 8
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tcdi.situacaolegal = 0
          and not exists (
            select 1
            from tceDeducaoCancelamentoEst tdc
            where tdc.entidade = tcdi.entidade
              and tdc.exercicio = tcdi.exercicio
              and tdc.idcancelamento = tcdi.idcancelamento
              and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
        )
        union all
        select md.idato,
               tc.nrdeducao as nrDeducao,
               tc.nranodeducao as nrAnoDeducao,
               tep.data as dtEstorno,
               tpd.valordesconto as vlEstorno,
               substr(md.descricao, 0, 250) as dsMotivo,
               0 as idcancelamento,
               0 as entidade,
               0 as exercicio,
               tepi.idpagamentobloqueto,
               0 as idcreditocontribuinteitem,
               tepi.iddebitoparcelareceita,
               0 as idParcelamento
        from tribpagamentodebito           tpd
                 join tribEstornoPagamentoItem tepi on tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto and tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 join tribestornopagamento     tep  on tep.entidade = tepi.entidade and tep.exercicio = tepi.exercicio and tep.estorno = tepi.estorno
                 join tcededucaopagamento      tdp  on tpd.idpagamentobloqueto = tpd.idpagamentobloqueto and tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 join tceDeducaoCredito        tc   on tc.idtcededucaocredito = tdp.idtcededucaocredito
                 join contabancaria            cb   on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
                 left join tribmotivodesconto       md   on md.motivodesconto = tep.motivodesconto
        where tep.data between :dataInicial and :dataFinal
          and tep.entidade = :entidade
          and tpd.situacaolegal = 0
          and COALESCE(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceDeducaoPagamentoEst tdp
            where tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
              and tdp.idPagamentoBloqueto = tpd.idPagamentoBloqueto
        )
        union all
        select md.idato,
               tc.nrdeducao as nrDeducao,
               tc.nranodeducao as nrAnoDeducao,
               tcc.dataestorno as dtEstorno,
               tcci.valordesconto as vlEstorno,
               substr(md.descricao || '. ' || coalesce(tcc.observacaoestorno, ''), 0, 250) as dsMotivo,
               0 as idcancelamento,
               0 as entidade,
               0 as exercicio,
               0 as idpagamentobloqueto,
               tdcc.idcreditocontribuinteitem,
               tdcc.iddebitoparcelareceita,
               0 as idParcelamento
        from tribcreditocontribuinte          tcc
                 join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tceDeducaoCreditoCredito    tdcc on tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
                 join tceDeducaoCredito           tc   on tc.idtcededucaocredito = tdcc.idtcededucaocredito
                 left join tribmotivodesconto          md   on md.motivodesconto = tcc.motivodescontoestorno
        where tcc.dataestorno between :dataInicial and :dataFinal
          and tcc.entidade = :entidade
          and tcc.valorestornado > 0
          and tcci.valordesconto > 0
          and not exists (
            select 1
            from tceDeducaoCreditoCreditoEst tdcc
            where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
              and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
        )
        union all
        /*Estorno desconto de parcelamento voltando para a origem*/
        select tdcda.cdcontroleleiato                                    as idAto,
               tdcda.nrdeducao                                           as nrDeducao,
               tdcda.nranodeducao                                        as nrAnoDeducao,
               tep.dataestorno                                           as dtEstorno,
               sum(
                       case
                           when valores.parcela = valores.max_parcela then
                                       valores.valordescontoprincipal +
                                       valores.valordescontojuros +
                                       valores.valordescontomulta +
                                       valores.valordescontocorrecao -
                                       coalesce(
                                               (select sum(v.rateio_desconto_principal +
                                                           v.rateio_desconto_juros +
                                                           v.rateio_desconto_multa +
                                                           v.rateio_desconto_correcao)
                                                from vw_desconto_parcelamento v
                                                where v.idparcelamento = tp.idparcelamento
                                                  and v.iddebito = valores.iddebito
                                                  and v.receitaorigem = valores.receitaorigem
                                                  and v.parcela <> valores.parcela),
                                               0)
                           else
                                   valores.rateio_desconto_principal +
                                   valores.rateio_desconto_juros +
                                   valores.rateio_desconto_multa +
                                   valores.rateio_desconto_correcao end) as vlEstorno,
               'Estorno de parcelamento: ' || tep.motivo                 as dsMotivo,
               0                                                         as idCancelamento,
               0                                                         as entidade,
               0                                                         as exercicio,
               0                                                         as idPagamentoBloqueto,
               0                                                         as idCreditoContribuinteItem,
               valores.iddebitoparcelareceita                            as idDebitoParcelaReceita,
               tep.idparcelamento                                        as idParcelamento
        from tribestornoparcelamento tep
                 left outer join tribparcelamento tp
                                 on tp.idparcelamento = tep.idparcelamento
                 left outer join tribparamparcelamento tpp
                                 on tp.idparametroparcelamento = tpp.idparametroparcelamento
                 left outer join tribmotivodesconto tmd
                                 on tpp.motivoestorno = tmd.motivodesconto
                 left outer join tribtipooperacaotce ttot
                                 on tmd.idtipooperacaotce = ttot.idtipooperacaotce
                 left outer join tribmotivodesconto tmdjurosfinan
                                 on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
                 left outer join tribtipooperacaotce ttotjurosfinan
                                 on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
                 join vw_desconto_parcelamento valores
                      on valores.idparcelamento = tp.idparcelamento
                 left outer join tribdebito td
                                 on td.iddebito = valores.iddebito
                 left outer join tribreceita tr
                                 on td.entidade = tr.entidade
                                     and :exercicio = tr.exercicio
                                     and valores.receita = tr.receita
                 left outer join tcededucaoparc tdpda
                                 on tdpda.idparcelamento = tep.idparcelamento
                                     and tdpda.iddebitoparcelareceita =
                                         valores.iddebitoparcelareceita
                 left outer join tcededucaocredito tdcda
                                 on tdpda.idtcededucaocredito = tdcda.idtcededucaocredito
        where tep.dataestorno between :dataInicial and :dataFinal
          and tp.anocontrato = :exercicio
          and valores.situacaolegal = 0
          and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
          and exists(select 1
                     from tribestornoparcelamentodebito tepd
                     where tepd.idestornoparcelamento = tep.idestornoparcelamento
                       and tepd.iddebitoorigem > tepd.iddebitodestino)
          and not exists( select 1
                          from tcededucaoparcest tdpdae
                          where tdpdae.idparcelamento = tep.idparcelamento
                            and tdpdae.iddebitoparcelareceita = valores.iddebitoparcelareceita)
        group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato,
                 tdcda.idtipocredito,
                 tep.dataestorno,
                 'Estorno de parcelamento: ' || tep.motivo,
                 tep.idparcelamento,
                 valores.iddebitoparcelareceita
            /*Estorno desconto de parcelamento nova subdivida*/
        union all
        select tdcda.cdcontroleleiato                                    as idAto,
               tdcda.nrdeducao                                           as nrDeducao,
               tdcda.nranodeducao                                        as nrAnoDeducao,
               tep.dataestorno                                           as dtEstorno,
               sum(
                       case
                           when valores.parcela = valores.max_parcela then
                                       valores.valordescontoprincipal +
                                       valores.valordescontojuros +
                                       valores.valordescontomulta +
                                       valores.valordescontocorrecao -
                                       coalesce(
                                               (select sum(v.rateio_desconto_principal +
                                                           v.rateio_desconto_juros +
                                                           v.rateio_desconto_multa +
                                                           v.rateio_desconto_correcao)
                                                from vw_desc_parcelamento_prox_sub v
                                                where v.idparcelamento = tp.idparcelamento
                                                  and v.iddebito = valores.iddebito
                                                  and v.receitaorigem = valores.receitaorigem
                                                  and v.parcela <> valores.parcela),
                                               0)
                           else
                                   valores.rateio_desconto_principal +
                                   valores.rateio_desconto_juros +
                                   valores.rateio_desconto_multa +
                                   valores.rateio_desconto_correcao end  ) as vlEstorno,
               'Estorno de parcelamento: ' || tep.motivo                 as dsMotivo,
               0                                                         as idCancelamento,
               0                                                         as entidade,
               0                                                         as exercicio,
               0                                                         as idPagamentoBloqueto,
               0                                                         as idCreditoContribuinteItem,
               valores.iddebitoparcelareceita                            as idDebitoParcelaReceita,
               tep.idparcelamento                                        as idParcelamento
        from tribestornoparcelamento tep
                 left outer join tribparcelamento tp
                                 on tp.idparcelamento = tep.idparcelamento
                 left outer join tribparamparcelamento tpp
                                 on tp.idparametroparcelamento = tpp.idparametroparcelamento
                 left outer join tribmotivodesconto tmd
                                 on tpp.motivoestorno = tmd.motivodesconto
                 left outer join tribtipooperacaotce ttot
                                 on tmd.idtipooperacaotce = ttot.idtipooperacaotce
                 left outer join tribmotivodesconto tmdjurosfinan
                                 on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
                 left outer join tribtipooperacaotce ttotjurosfinan
                                 on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
                 join vw_desc_parcelamento_prox_sub valores
                      on valores.idparcelamento = tp.idparcelamento
                 left outer join tribdebito td
                                 on td.iddebito = valores.iddebito
                 left outer join tribreceita tr
                                 on td.entidade = tr.entidade
                                     and :exercicio = tr.exercicio
                                     and valores.receita = tr.receita
                 left outer join tcededucaoparc tdpda
                                 on tdpda.idparcelamento = tep.idparcelamento
                                     and tdpda.iddebitoparcelareceita =
                                         valores.iddebitoparcelareceita
                 left outer join tcededucaocredito tdcda
                                 on tdpda.idtcededucaocredito = tdcda.idtcededucaocredito
        where tep.dataestorno between :dataInicial and :dataFinal
          and tp.anocontrato = :exercicio
          and valores.situacaolegal = 0
          and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
          and exists(select 1
                     from tribestornoparcelamentodebito tepd
                     where tepd.idestornoparcelamento = tep.idestornoparcelamento
                       and tepd.iddebitoorigem < tepd.iddebitodestino)
          and not exists( select 1
                          from tcededucaoparcest tdpdae
                          where tdpdae.idparcelamento = tep.idparcelamento
                            and tdpdae.iddebitoparcelareceita = valores.iddebitoparcelareceita)
        group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato,
                 tdcda.idtipocredito,
                 tep.dataestorno,
                 'Estorno de parcelamento: ' || tep.motivo,
                 tep.idparcelamento,
                 valores.iddebitoparcelareceita
    ) filtro
order by filtro.dtEstorno,
         filtro.nrDeducao,
         filtro.nrAnoDeducao,
         filtro.idAto
