select filtro.nrAtualizacao,
       filtro.nrAnoAtualizacao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idPagamentoBloqueto,
       filtro.idParcelamento,
       filtro.idEstornoParcelamento,
       filtro.idCreditoContribuinteItem,
       filtro.idDebitoParcelaReceita,
       filtro.idTipoAtualizacaoCredito,
       filtro.idTipoCredito
from
    (
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorjuros as vlEstorno,
               substr(tmd.descricao || '.' || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita tdpr on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 left join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
                 left join contabancaria cb on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valormulta as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita tdpr on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 left join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
                 left join contabancaria cb on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorcorrecao as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita tdpr on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
                 left join contabancaria cb on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorjuros as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita tdpr on tcci.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
                 left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancaria = cb.contabancaria
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valormulta as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita tdpr on tcci.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
                 left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancaria = cb.contabancaria
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorcorrecao as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita,
               0 as idTipoAtualizacaoCredito,
               trt.classificacaoreceitatipo as idTipoCredito
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita tdpr on tcci.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
                 join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
                 left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancaria = cb.contabancaria
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        select
            (select tida.nratualizacao
             from  tceatualizamoneparcda tdida
                       join tceatualizamonecredda tida on tdida.idtceatualizamonecredda = tida.idtceatualizamonecredda
             where tdida.idparcelamento = valores.idparcelamento
               and tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
               and tida.idtipoatualizacaocredito = valores.tipoAtualizacao
               and tida.idtipocredito = tcrt.classificacaoreceitatipo)           as nrAtualizacao,
            extract(year from tp.dataparcelamento)         as nrAnoAtualizacao,
            extract(month from tep.dataestorno) as nrMes,
            extract(year  from tep.dataestorno) as nrAno,
            tmd.idato,
            tep.dataestorno as dtEstorno,
            valores.valor                 as vlEstorno,
            substr(tmd.descricao || '.'  || tep.motivo, 0, 250) as dsMotivo,
            0 as idPagamentoBloqueto,
            tp.idParcelamento,
            0 as idEstornoParcelamento,
            0 as idCreditoContribuinteItem,
            valores.iddebitoparcelareceita,
            valores.tipoAtualizacao as idTipoAtualizacaoCredito,
            tcrt.classificacaoreceitatipo as idTipoCredito
        from tribestornoparcelamento tep
                 left join tribparcelamento tp on tp.idparcelamento = tep.idparcelamento
                 left join (select case
                                       when x.parcela = x.max_parcela then
                                                   x.valorjuros + x.valorjurosfinan + x.juros_financiamento_extra -
                                                   coalesce((select sum(y.rateio_juros + y.rateio_juros_financiamento)
                                                             from vw_atualizacao_parcelamento y
                                                             where y.idparcelamento = x.idparcelamento
                                                               and y.iddebito = x.iddebito
                                                               and y.receitaorigem = x.receitaorigem
                                                               and y.parcela <> x.max_parcela), 0)
                                       else x.rateio_juros + x.rateio_juros_financiamento + x.juros_financiamento_extra end as valor,
                                   x.idparcelamento,
                                   x.iddebitoparcelareceita,
                                   1                           as tipoAtualizacao,
                                   x.receita,
                                   x.guiarecolhimento,
                                   x.situacaolegal,
                                   'J' as classificacao
                            from tribestornoparcelamento tep2
                                     inner join vw_atualizacao_parcelamento x on x.idparcelamento = tep2.idparcelamento
                            where x.rateio_juros + x.rateio_juros_financiamento > 0
                              and tep2.dataestorno between :dataInicial and :dataFinal
                              and x.situacaolegal in (1, 2)
                            union
                            select case
                                       when x.parcela = x.max_parcela then
                                               x.valormulta - coalesce((select sum(y.rateio_multa)
                                                                        from vw_atualizacao_parcelamento y
                                                                        where y.idparcelamento = x.idparcelamento
                                                                          and y.iddebito = x.iddebito
                                                                          and y.receitaorigem = x.receitaorigem
                                                                          and y.parcela <> x.max_parcela), 0)
                                       else x.rateio_multa end as valor,
                                   x.idparcelamento,
                                   x.iddebitoparcelareceita,
                                   2                           as tipoAtualizacao,
                                   x.receita,
                                   x.guiarecolhimento,
                                   x.situacaolegal,
                                   'M' as classificacao
                            from tribestornoparcelamento tep2
                                     inner join vw_atualizacao_parcelamento x on x.idparcelamento = tep2.idparcelamento
                            where x.rateio_multa > 0
                              and tep2.dataestorno between :dataInicial and :dataFinal
                              and x.situacaolegal in (1, 2)
                            union
                            select case
                                       when x.parcela = x.max_parcela then
                                               x.valorcorrecao - coalesce((select sum(y.rateio_correcao)
                                                                           from vw_atualizacao_parcelamento y
                                                                           where y.idparcelamento = x.idparcelamento
                                                                             and y.iddebito = x.iddebito
                                                                             and y.receitaorigem = x.receitaorigem
                                                                             and y.parcela <> x.max_parcela), 0)
                                       else x.rateio_correcao end as valor,
                                   x.idparcelamento,
                                   x.iddebitoparcelareceita,
                                   3                              as tipoAtualizacao,
                                   x.receita,
                                   x.guiarecolhimento,
                                   x.situacaolegal,
                                   'C' as classificacao
                            from tribestornoparcelamento tep2
                                     inner join vw_atualizacao_parcelamento x on x.idparcelamento = tep2.idparcelamento
                            where x.rateio_correcao > 0
                              and tep2.dataestorno between :dataInicial and :dataFinal
                              and x.situacaolegal in (1, 2)) as valores
                           on valores.idparcelamento = tp.idparcelamento
                 left join tribreceita tr
                           on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
                 left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                 left join tribclassificacaoreceitatipo tcrt on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
                 left join tribparamparcelamento         tpp   on tpp.idparametroparcelamento =  tp.idparametroparcelamento
                 left join tribmotivodesconto            tmd   on tmd.motivodesconto = tpp.motivoestorno
        where tep.dataestorno between :dataInicial and :dataFinal
          and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
          and  (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
          and     exists (select 1 from tribestornoparcelamentodebito tepd
                          where tepd.idestornoparcelamento = tep.idestornoparcelamento
                            and tepd.iddebitoorigem > tepd.iddebitodestino)
          and  tp.anocontrato = :exercicio
          and valores.situacaolegal in (1, 2)
          and not exists (select 1 from tceatualizamoneparcdaest tampde where tampde.idparcelamento= tp.idparcelamento and tampde.iddebitoparcelareceita = valores.iddebitoparcelareceita)
    ) filtro
order by filtro.dtEstorno,
         filtro.nrAtualizacao,
         filtro.nrAnoAtualizacao,
         filtro.idAto
