select filtro.nrArrecadacao,
       filtro.nrAnoArrecadacao,
       filtro.vlEstorno,
       filtro.dtEstorno,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.iddebitoparcelareceita,
       filtro.idretencao
from (SELECT atc.nrArrecadacao,
             atc.nrAnoArrecadacao,
             tpd.valorpago as vlEstorno,
             tep.data      as dtEstorno,
             tpd.idpagamentobloqueto,
             0             as idcreditocontribuinteitem,
             tpd.iddebitoparcelareceita,
             0 as idretencao
      from tribestornopagamento tep
               join tribestornopagamentoitem tepi
                    on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
               join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and
                                               tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               join contabancaria cb on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
               left join tceArrTipoCreditoPagamento atcp on atcp.idpagamentobloqueto = tepi.idpagamentobloqueto and
                                                            atcp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
               left join tceArrecadacaoTipoCredito atc on atc.idtcearrtipocredito = atcp.idtcearrtipocredito
               left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
               left join tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
      where tep.entidade = :entidade
        and tep.data BETWEEN :dataInicial AND :dataFinal
        and tpd.valorpago > 0
        and tep.geracreditocontribuinte = 'N'
        and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and not exists (select 1
                        from tceArrTipoCreditoPagamentoEst atcp
                        where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                          and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
      union all
      SELECT atc.nrArrecadacao,
             atc.nrAnoArrecadacao,
             tcci.valorestornado as vlEstorno,
             tcc.dataestorno     as dtEstorno,
             0                   as idpagamentobloqueto,
             tcci.idcreditocontribuinteitem,
             tcci.iddebitoparcelareceita,
             0 as idretencao
      from tribcreditocontribuinte tcc
               join tribCreditoContribuinteItem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancariaestorno = cb.contabancaria
               left join tcearrtipocreditocredito atcc
                         on atcc.idcreditoContribuinteItem = tcci.idCreditoContribuinteItem and
                            atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tceArrecadacaoTipoCredito atc on atc.idtcearrtipocredito = atcc.idtcearrtipocredito
               left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
               left join tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
      where tcc.entidade = :entidade
        and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
        and tcc.valorestornado > 0
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
        and not exists (select 1
                        from tceArrTipoCreditoCreditoEst atcc
                        where atcc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                          and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
         SELECT
             atc.nrArrecadacao,
             atc.nrAnoArrecadacao,
             trc.valor as vlEstorno,
             trc.dtlancamento     as dtEstorno,
             0                   as idpagamentobloqueto,
             0                   as idcreditocontribuinteitem,
             0                   as iddebitoparcelareceita,
             trc.IdRetencaoContabil as idretencao
         from tceRetencaoContabil trc
                  join tcearrtipocreditoretencao rlc on trc.idretencaocontabil = rlc.idretencaocontabil
                  join tceArrecadacaoTipoCredito atc on rlc.idtcearrtipocredito = atc.idtcearrtipocredito
      where (trc.dtlancamento BETWEEN :dataInicial AND :dataFinal)
        and trc.devolucao = 'S'
        and not exists (
          select 1 from tcearrtipocreditoretencaoest tatcre
          where tatcre.idretencaocontabil = trc.idRetencaoContabil
          )) filtro
order by filtro.dtEstorno,
         filtro.nrArrecadacao,
         filtro.nrAnoArrecadacao
