select 07                                      as codigoArquivo,
       'Inscrição de Créditos em Dívida Ativa' as arquivo,
       'DEBITO'                                as tipoArquivo,
       arquivo.valor                           as valorArquivo,
       integracao.valor                        as valorIntegracao,
       0                                       as valorRetencao
from (
         select sum(filtro.valor) as valor
         from (select sum(ticd.vlinscricao) valor
               from tceInscCreditoDA ticd

               where ticd.dtinscricao between :dataInicial and :dataFinal
              ) filtro
     ) as arquivo
         cross join (select sum(valor) as valor
                     from (select coalesce(iip.valor, 0) as valor
                           from integracaopatrimonial ip
                                    left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                                    left join tribreceita r
                                              on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                                 r.entidade = ip.entidade
                                    JOIN tribreceitatipo trt
                                         ON trt.tiporeceita = r.tiporeceita
                           where ip.entidade = :entidade
                             and ip.datamovimento between :dataInicial and :dataFinal
                             and iip.tipomovimento = 'INSCRICAO'
                             and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                             and iip.situacaolegal in (1,2)
                             and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE') as dados
) as integracao