select 04                                          as codigoArquivo,
       'Estorno Atualização Monetária de créditos' as arquivo,
       'DEBITO'                                    as tipoArquivo,
       coalesce(arquivo.valor,0)                   as valorArquivo,
       coalesce(integracao.valor,0)                as valorIntegracao,
       0                                           as valorRetencao
from (
         select sum(filtro.valor) as valor
         from (
                  select coalesce(tamce.vlestorno, 0) as valor
                  from tceatualizamonecredest tamce
                  where tamce.dtestorno between :dataInicial and :dataFinal)
                  filtro) as arquivo
         cross join (
    select sum(filtro.valor) as valor
    from (select sum(coalesce(liic.valortributo, 0)) as valor
          from loteintegracaocontabil lic
                   left join loteitemintegracaocontabil liic on lic.id = liic.idlote
                   left join tribreceita tr on liic.idtributo = tr.id
                   left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
          where (lic.datalote BETWEEN :dataInicial AND :dataFinal)
            and lic.entidade = :entidade
            and liic.situacaolegal = 0
            and liic.classificacaotributo in ('J', 'M', 'C')
            and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
            and lic.tipoLote in ('ESTORNO_PAGAMENTO', 'ESTORNO_CREDITO')
            and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
          union all
          select iip.valor as valor
          from integracaopatrimonial ip
                   left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                   left join tribreceita r
                             on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                r.entidade = ip.entidade
                   JOIN tribreceitatipo trt
                        ON trt.tiporeceita = r.tiporeceita
          where ip.entidade = :entidade
            and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
            and ip.datamovimento between :dataInicial and :dataFinal
            and iip.tipomovimento in ('ESTORNO_ACRESCIMOS_PARCELAMENTO')
            and iip.situacaolegal = 0
            and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE') as filtro) as integracao