select filtro.idTipoAtualizacaoCredito,
       filtro.dtAtualizacao,
       filtro.nrcredito,
       filtro.nranocredito,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.idCreditoContribuinteItem,
       filtro.idparcelamento,
       filtro.vlAtualizacao,
       tg.fundamentolegal  as cdControleLeiAto,
       filtro.idTipoCredito
from (select 1                 as idTipoAtualizacaoCredito,
             tpd.valorjuros    as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 2                 as idTipoAtualizacaoCredito,
             tpd.valormulta    as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 3                 as idTipoAtualizacaoCredito,
             tpd.valorcorrecao as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 1               as idTipoAtualizacaoCredito,
             tcci.valorjuros as vlAtualizacao,
             0               as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             0               as idparcelamento,
             tcc.data        as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorjuros > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select 2               as idTipoAtualizacaoCredito,
             tcci.valormulta as vlAtualizacao,
             0               as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             0               as idparcelamento,
             tcc.data        as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valormulta > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select 3                  as idTipoAtualizacaoCredito,
             tcci.valorcorrecao as vlAtualizacao,
             0                  as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             0                  as idparcelamento,
             tcc.data           as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorcorrecao > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select distinct
             valores.tipoAtualizacao       as idTipoAtualizacaoCredito,
             valores.valor                 as vlAtualizacao,
             0                             as idpagamentobloqueto,
             valores.iddebitoparcelareceita,
             0                             as idcreditocontribuinteitem,
             tp.idparcelamento,
             tp.dataparcelamento           as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             valores.guiarecolhimento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribparcelamento tp
               left join (select case
                                     when x.parcela = x.max_parcela then
                                                 x.valorjuros + x.valorjurosfinan -
                                                 coalesce((select sum(y.rateio_juros + y.rateio_juros_financiamento)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = x.idparcelamento
                                                             and y.iddebito = x.iddebito
                                                             and y.receitaorigem = x.receitaorigem
                                                             and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_juros + x.rateio_juros_financiamento end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 1                           as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.rateio_juros + x.rateio_juros_financiamento > 0
                            and x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal = 0
                          union
                          select case
                                     when x.parcela = x.max_parcela then
                                             x.valormulta - coalesce((select sum(y.rateio_multa)
                                                                      from vw_atualizacao_parcelamento y
                                                                      where y.idparcelamento = x.idparcelamento
                                                                        and y.iddebito = x.iddebito
                                                                        and y.receitaorigem = x.receitaorigem
                                                                        and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_multa end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 2                           as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.rateio_multa > 0
                            and x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal = 0
                          union
                          select case
                                     when x.parcela = x.max_parcela then
                                             x.valorcorrecao - coalesce((select sum(y.rateio_correcao)
                                                                         from vw_atualizacao_parcelamento y
                                                                         where y.idparcelamento = x.idparcelamento
                                                                           and y.iddebito = x.iddebito
                                                                           and y.receitaorigem = x.receitaorigem
                                                                           and y.parcela <> x.max_parcela), 0)
                                     else x.rateio_correcao end as valor,
                                 x.idparcelamento,
                                 x.iddebitoparcelareceita,
                                 3                              as tipoAtualizacao,
                                 x.receita,
                                 x.guiarecolhimento,
                                 x.situacaolegal
                          from vw_atualizacao_parcelamento x
                          where x.rateio_correcao > 0
                            and x.dataparcelamento between :dataInicial and :dataFinal
                            and x.situacaolegal = 0) as valores
                         on valores.idparcelamento = tp.idparcelamento
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = valores.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join tribreceita tr
                         on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
               left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               left join tribclassificacaoreceitatipo tcrt
                         on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
               left join tceatualizamoneparc tampcd on valores.idparcelamento = tampcd.idparcelamento and
                                                       tampcd.iddebitoparcelareceita = valores.iddebitoparcelareceita
      where tp.dataparcelamento between :dataInicial and :dataFinal
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and valores.situacaolegal = 0
        and tampcd.idtceatualizamonecred is null
        and valores.valor > 0 ) filtro
         left join tribguiarecolhimento     tg on tg.entidade = :entidade
    and tg.exercicio = :exercicio
    and tg.guiarecolhimento = filtro.guiarecolhimento
order by filtro.dtAtualizacao,
         filtro.nrcredito,
         filtro.nranocredito,
         filtro.idpagamentobloqueto,
         filtro.iddebitoparcelareceita,
         filtro.idTipoAtualizacaoCredito;
