SELECT x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       x.tipodeducao,
       'CANCELAMENTO' as tipomovimento,
       x.iddebito,
       x.tipoTributo,
       x.iddebitoparcelareceita,
       sum(x.valor) as valor
from (
select distinct
      td.entidade,
      case
         when td.datacontabilizacao >= tdp.datalancamento then td.datacontabilizacao
         when td.datainclusao > tdp.datalancamento then td.datainclusao
         else tdp.datalancamento
       end datamovimentacao,
       null as idparcelamento,
       td.iddebito,
       tr.id as idtributo,
       tdr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       tr.tiporeceita as tipoTributo,
       0 as situacaolegal,
       tdpr.iddebitoparcelareceita,
       dados.tipodeducao,
       dados.tipodeducao_descr,
       dados.tipooperacaodeducao,
       dados.valorisencao as valor
from tribdebito td
left outer join tribdebitoparcela tdp
 on td.entidade         = tdp.entidade
and td.exercicio        = tdp.exercicio
and td.tipocadastro     = tdp.tipocadastro
and td.cadastrogeral    = tdp.cadastrogeral
and td.guiarecolhimento = tdp.guiarecolhimento
and td.subdivida        = tdp.subdivida
left outer join tribdebitoparcelareceita tdpr
 on tdp.entidade         = tdpr.entidade
and tdp.exercicio        = tdpr.exercicio
and tdp.tipocadastro     = tdpr.tipocadastro
and tdp.cadastrogeral    = tdpr.cadastrogeral
and tdp.guiarecolhimento = tdpr.guiarecolhimento
and tdp.subdivida        = tdpr.subdivida
and tdp.parcela          = tdpr.parcela
left outer join tribsituacaoparcela tsp
 on tdp.situacaodebito = tsp.situacaoparcela
left outer join tribcadastrogeral tcg
 on td.tipocadastro = tcg.tipocadastro
and td.cadastrogeral = tcg.cadastrogeral
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and :exercicio = tr.exercicio
and tdr.receita   = tr.receita
left outer join (select isrec.entidade,
                        isrec.exercicio,
                        isrec.tipocadastro,
                        isrec.cadastrogeral,
                        isrec.guiarecolhimento,
                        isrec.subdivida,
                        isrec.receita,
                        ttd.tipodeducao,
                        ttd.descricao as tipodeducao_descr,
                        ttot.codigotce as tipooperacaodeducao,
                        sum(isrec.valorisencao) as valorisencao
                  from tribdebitoreceitaisencao isrec
                  left outer join tribisencao tirec
                   on tirec.isencao = isrec.isencao
                  left outer join tribmotivodesconto tmd
                  on tirec.motivodesconto = tmd.motivodesconto
                  left outer join tribtipodeducao ttd
                  on tmd.tipodeducao = ttd.tipodeducao
                  left outer join tribtipooperacaotce ttot
                  on tmd.idtipooperacaotce = ttot.idtipooperacaotce
                  where isrec.valorisencao > 0
                  group by isrec.entidade, isrec.exercicio, isrec.tipocadastro, isrec.cadastrogeral, isrec.guiarecolhimento, isrec.subdivida, isrec.receita,
                           ttd.tipodeducao, ttd.descricao, ttot.codigotce
) dados
 on dados.entidade         = tdr.entidade
and dados.exercicio        = tdr.exercicio
and dados.tipocadastro     = tdr.tipocadastro
and dados.cadastrogeral    = tdr.cadastrogeral
and dados.guiarecolhimento = tdr.guiarecolhimento
and dados.subdivida        = tdr.subdivida
and dados.receita          = tdr.receita
where td.constituido = 'S'
  and dados.valorisencao > 0
  and ((td.datacontabilizacao >= tdp.datalancamento and td.datacontabilizacao in (:datasMovimento)) or
         (((td.datacontabilizacao is null) or (td.datacontabilizacao < tdp.datalancamento)) and
          ((td.datainclusao >= tdp.datalancamento and td.datainclusao in (:datasMovimento))
            or (((td.datainclusao is null) or (td.datainclusao < tdp.datalancamento))  and tdp.datalancamento in (:datasMovimento)))))
) x
group by x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       x.iddebito,
       x.tipodeducao,
       x.tipoTributo,
       x.iddebitoparcelareceita