select td.entidade,
       tep.dataestorno         as datamovimentacao,
       tr.receita              as tributo,
       tr.descricao            as descricaotributo,
       tr.tiporeceita          as tipoTributo,
       desconto.classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
         then tdp.situacaolegal
         else 0
       end                     situacaolegal,
       null                    as tipooperacaodeducao,
       'ESTORNO_DESCONTO_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       desconto.iddebitoparcelareceita,
       desconto.valor    as valor
from   tribestornoparcelamento tep
			left join (select
                           x.idparcelamento,
                           'P'            as classificacaotributo,
                           x.rateio_desconto_principal as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_principal > 0
                        union
						select
                           x.idparcelamento,
                           'J'            as classificacaotributo,
                           x.rateio_desconto_juros as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_juros > 0
                        union
						select
                           x.idparcelamento,
                           'M'            as classificacaotributo,
                           x.rateio_desconto_multa as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_multa > 0
                        union
						select
                           x.idparcelamento,
                           'C'            as classificacaotributo,
                           x.rateio_desconto_correcao as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.receita,
                           x.guiarecolhimento,
                           x.parcela,
                           x.situacaolegal
                      	from vw_desc_parcelamento_prox_sub x
                      	where x.rateio_desconto_correcao > 0) desconto
                    on desconto.idparcelamento = tep.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = desconto.iddebito
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = desconto.parcela
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and desconto.receita = tr.receita
       left outer join tribparcelamento tp on tp.idparcelamento = tep.idparcelamento
where  td.constituido = 'S'
  and  tep.dataestorno in (:datasMovimento)
  and  tp.anocontrato = :exercicio
  and  (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)