SELECT x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       x.tipodeducao,
       x.tipoTributo,
       CASE
         WHEN x.tipodeducao = 6 THEN 'DACAO_PAGAMENTO'
         WHEN x.tipodeducao = 8 THEN 'ESTORNO_INSCRICAO'
         ELSE 'CANCELAMENTO'
       END as tipomovimento,
       x.iddebito,
       x.iddebitoparcelareceita,
       x.valor as valor
from (
select td.entidade,
       tcd.datacancelamento as datamovimentacao,
       null as idparcelamento,
       td.iddebito,
       tr.id as idtributo,
       tdpr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       tr.tiporeceita as tipoTributo,
       tcdi.situacaolegal,
       ttd.tipodeducao,
       ttd.descricao as tipodeducao_descr,
       ttot.codigotce as tipooperacaodeducao,
       tcdi.iddebitoparcelareceita,
       sum(coalesce(tcdi.valor,0)) as valor
from tribcancelamentodebito tcd
left outer join tribcancelamentodebitoitem tcdi
 on tcd.entidade = tcdi.entidade
and tcd.exercicio = tcdi.exercicio
and tcd.idcancelamento = tcdi.idcancelamento
left outer join tribdebitoparcelareceita tdpr
 on tcdi.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
left outer join tribreceita tr
on tdpr.entidade = tr.entidade
and :exercicio = tr.exercicio
and tdpr.receita = tr.receita
left outer join tribdebito td
 on tdpr.entidade = td.entidade
and tdpr.exercicio = td.exercicio
and tdpr.tipocadastro = td.tipocadastro
and tdpr.cadastrogeral = td.cadastrogeral
and tdpr.guiarecolhimento = td.guiarecolhimento
and tdpr.subdivida = td.subdivida
left outer join tribmotivodesconto tmd
 on tcd.motivocancelamento = tmd.motivodesconto
left outer join tribtipodeducao ttd
 on tmd.tipodeducao = ttd.tipodeducao
left outer join tribtipooperacaotce ttot
on tmd.idtipooperacaotce = ttot.idtipooperacaotce
where td.constituido = 'S'
and tcd.datacancelamento in (:datasMovimento)
and not exists (select 1 from tribestornoparcelamentodebito tepd
                left outer join tribestornoparcelamento tep
                on tepd.idestornoparcelamento = tep.idestornoparcelamento
                where (tepd.iddebitoorigem = td.iddebito and tcd.datacancelamento = tep.dataestorno)
                   or (tepd.iddebitodestino = td.iddebito and tep.estornado = 'S' and tcd.datacancelamento = tep.datareabilitacao))
  and not exists (select 1
                  from tribpgtonegociadodebitoorigem tpndo
                  where tpndo.entidade = tdpr.entidade
                    and tpndo.exercicio = tdpr.exercicio
                    and tpndo.tipocadastro = tdpr.tipocadastro
                    and tpndo.cadastrogeral = tdpr.cadastrogeral
                    and tpndo.guiarecolhimento = tdpr.guiarecolhimento
                    and tpndo.subdivida = tdpr.subdivida
                    and tpndo.parcela = tdpr.parcela)
group by td.entidade,
       tcd.datacancelamento,
       td.iddebito,
       tcdi.iddebitoparcelareceita,
       tr.id,
       tdpr.receita,
       tr.descricao,
       tr.classificacao,
       tr.tiporeceita,
       tcdi.situacaolegal,
       ttd.tipodeducao,
       ttd.descricao,
       ttot.codigotce
) x