select td.entidade,
       acrescimo.dataparcelamento       as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       tr.tiporeceita            as tipoTributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when acrescimo.situacaolegal <> 0 and ( acrescimo.datadividaativa is null or acrescimo.datadividaativa <= acrescimo.dataparcelamento )
         then acrescimo.situacaolegal
         else 0
       end                       situacaolegal,
       null                      as tipooperacaodeducao,
       'ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       acrescimo.iddebito,
       acrescimo.iddebitoparcelareceita,
       acrescimo.valor      as valor
       from (select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.jurosdestino as tributo,
                               vap.rateio_juros   as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_juros > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.multadestino as tributo,
                               vap.rateio_multa   as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_multa > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.correcaodestino as tributo,
                               vap.rateio_correcao   as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_correcao > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.jurosfinandestino as tributo,
                               (vap.rateio_juros_financiamento + vap.juros_financiamento_extra) as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_juros_financiamento > 0) acrescimo
       left outer join tribdebito td
                    on td.iddebito = acrescimo.iddebito
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and acrescimo.tributo = tr.receita
  where acrescimo.dataparcelamento in (:datasMovimento)
  and td.constituido = 'S'