SELECT D.ENTIDADE,
       D.EXERCICIO AS EXERCICIOCREDITO,
       D.CREDITOCONTRIBUINTE AS CREDITO,
       D.DATA AS DATAMOVIMENTACAO,
       E.VALORPRINCIPAL,
       E.VALORJUROS,
       E.VALORMULTA,
       E.VALORCORRECAO,
       CASE
         WHEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0) > 0
           THEN COALESCE(E.VALORDESCONTOPRINCIPAL,0) + COALESCE(E.VALORDESCONTOJUROS,0) + COALESCE(E.VALORDESCONTOMULTA,0) + COALESCE(E.VALORDESCONTOCORRECAO,0) + COALESCE(E.VALORDESCONTOJUROSFINAN, 0)
           ELSE COALESCE(E.VALORDESCONTO,0)
       END AS VALORDESCONTO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBCREDITOCONTRIBUINTE D
LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM E
 ON D.ENTIDADE = E.ENTIDADE
AND D.EXERCICIO = E.EXERCICIO
AND D.CREDITOCONTRIBUINTE = E.CREDITOCONTRIBUINTE
LEFT OUTER JOIN CONTABANCARIA CB
 ON D.ENTIDADE = CB.ENTIDADE
AND D.CONTABANCARIA = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON E.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'