	select cdi.tipocadastro,
		   cdi.cadastrogeral,
		   cdi.pessoa,
		   p.nome,
		   cdi.exercicio,
		   cdi.divida,
		   dpr.subdivida,
		   dpr.parcela,
		   gr.descricao as descricaoDivida,
		   sum(cdi.valor) as valor,
		   sum(cdi.valorjuros) as valorJuros,
		   sum(cdi.valormulta) as valorMulta,
		   sum(cdi.valorcorrecao) as valorCorrecao,
		   sum(cdi.valorliquido) as valorLiquido
	  from consultadebito cd
	  join consultadebitoitem cdi
		on cd.id = cdi.idconsultadebito
 left join pessoa p
		on cdi.pessoa = p.pessoa
 left join tribguiarecolhimento gr
		on cdi.entidade = gr.entidade
	   and cdi.exercicio = gr.exercicio
	   and cdi.divida = gr.guiarecolhimento
 left join tribreceitatipo rt
 		on cdi.tipotributo = rt.tiporeceita
 left join tribdebitoparcelareceita dpr
 		on dpr.iddebitoparcelareceita = cdi.iddebitotributo
	 where cd.id = :idConsulta
  group by dpr.parcela,
  		   cdi.tipocadastro,
	       cdi.cadastrogeral,
	       cdi.pessoa,
	       p.nome,
	       cdi.exercicio,
	       cdi.divida,
	       dpr.subdivida,
	       gr.descricao
  order by cdi.tipocadastro,
	       cdi.cadastrogeral,
	       cdi.divida,
	       dpr.subdivida,
	       dpr.parcela