/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.core.exception.EloValidationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;

public final class FileUtils {
    public static byte[] zipBytes(String filename, byte[] input) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(filename);
        try {
            zipEntry.setSize(input.length);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(input);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao compactar arquivo em .zip.");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static File createTempFile(String nome, String extensao, byte[] content) throws IOException {
        Objects.requireNonNull(nome, "O nome do arquivo tempor\u00e1rio precisa ser informado.");
        Objects.requireNonNull(extensao, "A extens\u00e3o do arquivo tempor\u00e1rio precisa ser informada.");
        Path path = Files.createTempFile(nome, extensao, new FileAttribute[0]);
        return Files.write(path, content, StandardOpenOption.CREATE).toFile();
    }

    @Generated
    private FileUtils() {
    }
}

