/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoAtualizacaoMonetariaCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoCreditoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoAtualizacaoMonetariaCreditoMaService
implements ManutencaoArquivoSimAmService<EstornoAtualizacaoMonetariaCreditoMaDTO> {
    private final EstornoAtualizacaoCreditoRepository estornoAtualizacaoCreditoRepository;
    private final AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository;
    private final AtoRepository atoRepository;
    private final EntityManager entityManager;
    private final ContextService contextService;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO;
    }

    public Page<EstornoAtualizacaoMonetariaCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification especification = StringUtils.isBlank((CharSequence)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoAtualizacaoCreditoRepository.findAll(especification, pageable).map(EstornoAtualizacaoMonetariaCreditoMaDTO::from);
    }

    public List<EstornoAtualizacaoMonetariaCreditoMaDTO> updateAll(List<EstornoAtualizacaoMonetariaCreditoMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoAtualizacaoMonetariaCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoAtualizacaoCreditoRepository.saveAll((Iterable)arquivos.stream().map(EstornoAtualizacaoMonetariaCreditoMaDTO::toEstAtualizacaoMonetariaCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoAtualizacaoMonetariaCreditoMaDTO> estArrecadacaoTipoCredito) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return estArrecadacaoTipoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaCdControleLeiAto(EstornoAtualizacaoMonetariaCreditoMaDTO estArrecadacaoTipoCredito, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, estArrecadacaoTipoCredito.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela EstornoAtualizacaoMonetariaCredito n\u00e3o est\u00e1 presente na tabela CgAto.", estArrecadacaoTipoCredito.getCdControleLeiAto(), estArrecadacaoTipoCredito.getIdTceAtualizaMoneCredEst()));
        }
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoMaService(EstornoAtualizacaoCreditoRepository estornoAtualizacaoCreditoRepository, AtualizacaoMonetariaCreditoRepository atualizacaoMonetariaCreditoRepository, AtoRepository atoRepository, EntityManager entityManager, ContextService contextService) {
        this.estornoAtualizacaoCreditoRepository = estornoAtualizacaoCreditoRepository;
        this.atualizacaoMonetariaCreditoRepository = atualizacaoMonetariaCreditoRepository;
        this.atoRepository = atoRepository;
        this.entityManager = entityManager;
        this.contextService = contextService;
    }
}

