/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.DeducaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DeducaoCreditoDAMaService
implements ManutencaoArquivoSimAmService<DeducaoCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final DeducaoCreditoDividaAtivaRepository deducaoCreditoDividaAtivaRepository;
    private final ContextService contextService;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA;
    }

    public Page<DeducaoCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtDeducao"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.deducaoCreditoDividaAtivaRepository.findAll(specification, pageable).map(DeducaoCreditoDividaAtivaMaDTO::from);
    }

    public List<DeducaoCreditoDividaAtivaMaDTO> updateAll(List<DeducaoCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(DeducaoCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.deducaoCreditoDividaAtivaRepository.saveAll((Iterable)arquivos.stream().map(DeducaoCreditoDividaAtivaMaDTO::toDeducaoCreditoDA).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<DeducaoCreditoDividaAtivaMaDTO> arrecadacaoTipoCredito) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return arrecadacaoTipoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrDivida(current);
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrDivida(DeducaoCreditoDividaAtivaMaDTO deducaoCreditoDividaAtivaMaDTO) {
        if (!this.inscricaoCreditoDividaAtivaRepository.existsByNrDividaAndNrAnoDivida(deducaoCreditoDividaAtivaMaDTO.getNrDivida(), deducaoCreditoDividaAtivaMaDTO.getNrAnoDivida()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de inscri\u00e7ao de cr\u00e9dito em divida ativa com a chave nrDivida/nrAnoDivida com os valores %s/%s.", deducaoCreditoDividaAtivaMaDTO.getNrDivida(), deducaoCreditoDividaAtivaMaDTO.getNrAnoDivida()));
        }
    }

    private void validaCdControleLeiAto(DeducaoCreditoDividaAtivaMaDTO deducaoCreditoDA, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, deducaoCreditoDA.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela DeducaoCreditoDA n\u00e3o est\u00e1 presente na tabela CgAto.", deducaoCreditoDA.getCdControleLeiAto(), deducaoCreditoDA.getId()));
        }
    }

    @Generated
    public DeducaoCreditoDAMaService(EntityManager entityManager, DeducaoCreditoDividaAtivaRepository deducaoCreditoDividaAtivaRepository, ContextService contextService, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository, AtoRepository atoRepository) {
        this.entityManager = entityManager;
        this.deducaoCreditoDividaAtivaRepository = deducaoCreditoDividaAtivaRepository;
        this.contextService = contextService;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
        this.atoRepository = atoRepository;
    }
}

