/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.AtualizacaoMonetariaCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaCreditoDAMaService
implements ManutencaoArquivoSimAmService<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository;
    private final ContextService contextService;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO_DIVIDA_ATIVA;
    }

    public Page<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtAtualizacao"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.atualizacaoMonetariaCreditoDARepository.findAll(specification, pageable).map(AtualizacaoMonetariaCreditoDividaAtivaMaDTO::from);
    }

    public List<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> updateAll(List<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(AtualizacaoMonetariaCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.atualizacaoMonetariaCreditoDARepository.saveAll((Iterable)arquivos.stream().map(AtualizacaoMonetariaCreditoDividaAtivaMaDTO::toAtualizacaoMonetariaCreditoDA).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> atualizacaoMonetariaCreditoDividaAtivaMaDTO) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return atualizacaoMonetariaCreditoDividaAtivaMaDTO.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaCdControleLeiAto(AtualizacaoMonetariaCreditoDividaAtivaMaDTO atualizacaoMonetariaCreditoDividaAtivaMaDTO, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, atualizacaoMonetariaCreditoDividaAtivaMaDTO.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela AtualizacaoMonetariaCreditoDA n\u00e3o est\u00e1 presente na tabela CgAto.", atualizacaoMonetariaCreditoDividaAtivaMaDTO.getCdControleLeiAto(), atualizacaoMonetariaCreditoDividaAtivaMaDTO.getId()));
        }
    }

    @Generated
    public AtualizacaoMonetariaCreditoDAMaService(EntityManager entityManager, AtualizacaoMonetariaCreditoDARepository atualizacaoMonetariaCreditoDARepository, ContextService contextService, AtoRepository atoRepository) {
        this.entityManager = entityManager;
        this.atualizacaoMonetariaCreditoDARepository = atualizacaoMonetariaCreditoDARepository;
        this.contextService = contextService;
        this.atoRepository = atoRepository;
    }
}

