/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.tributos.dto.SimamGeracaoDadosDTO;
import br.com.elotech.tributos.service.ExercicioMesService;
import br.com.elotech.tributos.service.batch.simam.ImplantacaoSaldoJobStarter;
import br.com.elotech.tributos.service.batch.simam.MovimentacaoMensalJobStarter;
import br.com.elotech.tributos.service.simam.SimAmGeracaoDadosService;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SimAmGeracaoDadosService {
    private final ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter;
    private final MovimentacaoMensalJobStarter movimentacaoMensalJobStarter;
    private final ExercicioMesService exercicioMesService;
    private static final Long COMPETENCIA_JANEIRO = 1L;

    public void iniciarTarefa(SimamGeracaoDadosDTO dados) throws Exception {
        LocalDate dataInicial = Objects.nonNull(dados.getExercicio()) && Objects.nonNull(dados.getCompetencia()) ? LocalDate.of(dados.getExercicio().intValue(), dados.getCompetencia().intValue(), 1) : null;
        LocalDate dataFinal = Objects.nonNull(dataInicial) ? dataInicial.with(TemporalAdjusters.lastDayOfMonth()) : dados.getDataFinal();
        Boolean substituir = Objects.nonNull(dados.getSubstituirCargaExistente()) ? dados.getSubstituirCargaExistente() : false;
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$simam$TipoProcessamentoDadosSimAm[dados.getTipoArquivo().ordinal()]) {
            case 1: {
                this.exercicioMesService.validaMesAberto(Long.valueOf(Month.JANUARY.getValue()), dados.getExercicio());
                this.implantacaoSaldoJobStarter.startJob(dados.getEntidade(), dados.getExercicio(), dataFinal, substituir);
                break;
            }
            case 2: {
                this.exercicioMesService.validaMesAberto(dados.getCompetencia(), dados.getExercicio());
                if (!Objects.equals(dados.getCompetencia(), COMPETENCIA_JANEIRO)) {
                    this.exercicioMesService.validaMesSeguinteAoUltimoFechado(dados.getCompetencia(), dados.getExercicio());
                }
                this.movimentacaoMensalJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade(), dados.getExercicio(), substituir.booleanValue());
                break;
            }
            default: {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Tipo de arquivo n\u00e3o implementado");
            }
        }
    }

    @Generated
    public SimAmGeracaoDadosService(ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter, MovimentacaoMensalJobStarter movimentacaoMensalJobStarter, ExercicioMesService exercicioMesService) {
        this.implantacaoSaldoJobStarter = implantacaoSaldoJobStarter;
        this.movimentacaoMensalJobStarter = movimentacaoMensalJobStarter;
        this.exercicioMesService = exercicioMesService;
    }
}

