/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.InscricaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class InscricaoCreditoDividaAtivaMaService
implements ManutencaoArquivoSimAmService<InscricaoCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;
    private final AtoRepository atoRepository;
    private final ContextService contextService;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.INSCRICAO_CREDITO_DIVIDA_ATIVA;
    }

    public Page<InscricaoCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dataInscricao"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.inscricaoCreditoDividaAtivaRepository.findAll(specification, pageable).map(InscricaoCreditoDividaAtivaMaDTO::from);
    }

    public List<InscricaoCreditoDividaAtivaMaDTO> updateAll(List<InscricaoCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(InscricaoCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.inscricaoCreditoDividaAtivaRepository.saveAll((Iterable)arquivos.stream().map(InscricaoCreditoDividaAtivaMaDTO::toInscricaoCreditoDA).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<InscricaoCreditoDividaAtivaMaDTO> arquivos) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return arquivos.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrDeducao(current);
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrDeducao(InscricaoCreditoDividaAtivaMaDTO inscricaoCreditoDividaAtivaMaDTO) {
        if (!this.lancamentoCreditoRepository.existsByNrCreditoAndNrAnoCredito(inscricaoCreditoDividaAtivaMaDTO.getNrCredito(), inscricaoCreditoDividaAtivaMaDTO.getNrAnoCredito()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de Dedu\u00e7\u00e3o de cr\u00e9dito com a chave NrDeducao/NrAnoDeducao com os valores %s/%s.", inscricaoCreditoDividaAtivaMaDTO.getNrCredito(), inscricaoCreditoDividaAtivaMaDTO.getNrAnoCredito()));
        }
    }

    private void validaCdControleLeiAto(InscricaoCreditoDividaAtivaMaDTO inscricaoCreditoDividaAtivaMaDTO, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, inscricaoCreditoDividaAtivaMaDTO.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela InscricaoCreditoDividaAtiva n\u00e3o est\u00e1 presente na tabela CgAto.", inscricaoCreditoDividaAtivaMaDTO.getCdControleLeiAto(), inscricaoCreditoDividaAtivaMaDTO.getId()));
        }
    }

    @Generated
    public InscricaoCreditoDividaAtivaMaService(EntityManager entityManager, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository, LancamentoCreditoRepository lancamentoCreditoRepository, AtoRepository atoRepository, ContextService contextService) {
        this.entityManager = entityManager;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
        this.atoRepository = atoRepository;
        this.contextService = contextService;
    }
}

