/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoInscricaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.EstornoInscricaoDividaAtivaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoInscricaoCreditoDAMaService
implements ManutencaoArquivoSimAmService<EstornoInscricaoCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final EstornoInscricaoDividaAtivaRepository estornoInscricaoDividaAtivaRepository;
    private final ContextService contextService;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_INSCRICAO_CREDITO_DIVIDA_ATIVA;
    }

    public Page<EstornoInscricaoCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoInscricaoDividaAtivaRepository.findAll(specification, pageable).map(EstornoInscricaoCreditoDividaAtivaMaDTO::from);
    }

    public List<EstornoInscricaoCreditoDividaAtivaMaDTO> updateAll(List<EstornoInscricaoCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoInscricaoCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoInscricaoDividaAtivaRepository.saveAll((Iterable)arquivos.stream().map(EstornoInscricaoCreditoDividaAtivaMaDTO::toEstornoInscricaoCreditoDA).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoInscricaoCreditoDividaAtivaMaDTO> arquivos) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return arquivos.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaCdControleLeiAto(EstornoInscricaoCreditoDividaAtivaMaDTO estornoInscricaoCreditoDividaAtivaMaDTO, Long entidade) {
        Optional<Long> idTce = this.atoRepository.findByIdTce(entidade, estornoInscricaoCreditoDividaAtivaMaDTO.getCdControleLeiAto()).map(Ato::getIdTce);
        if (idTce.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela EstornoInscricaoCreditoDividaAtiva n\u00e3o est\u00e1 presente na tabela CgAto.", estornoInscricaoCreditoDividaAtivaMaDTO.getCdControleLeiAto(), estornoInscricaoCreditoDividaAtivaMaDTO.getId()));
        }
    }

    @Generated
    public EstornoInscricaoCreditoDAMaService(EntityManager entityManager, EstornoInscricaoDividaAtivaRepository estornoInscricaoDividaAtivaRepository, ContextService contextService, AtoRepository atoRepository) {
        this.entityManager = entityManager;
        this.estornoInscricaoDividaAtivaRepository = estornoInscricaoDividaAtivaRepository;
        this.contextService = contextService;
        this.atoRepository = atoRepository;
    }
}

