/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.tributos.domain.sanepar.SaneparConfiguracao;
import br.com.elotech.tributos.dto.sanepar.SaneparConfiguracaoDTO;
import br.com.elotech.tributos.repository.sanepar.SaneparConfiguracaoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaneparConfiguracaoService {
    private final SaneparConfiguracaoRepository saneparConfiguracaoRepository;
    private final ContextService contextService;

    public SaneparConfiguracao findByEntidadeAndExercicio(Long idEntidade, Long idExercicio) {
        return this.saneparConfiguracaoRepository.findByEntidadeAndExercicio(idEntidade, idExercicio);
    }

    public Optional<SaneparConfiguracao> findAtual() {
        return Optional.ofNullable(this.findByEntidadeAndExercicio(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual()));
    }

    @Transactional
    public SaneparConfiguracao save(SaneparConfiguracaoDTO saneparConfiguracaoDTO) {
        return (SaneparConfiguracao)this.saneparConfiguracaoRepository.save((Object)saneparConfiguracaoDTO.toEntity());
    }

    @Generated
    public SaneparConfiguracaoService(SaneparConfiguracaoRepository saneparConfiguracaoRepository, ContextService contextService) {
        this.saneparConfiguracaoRepository = saneparConfiguracaoRepository;
        this.contextService = contextService;
    }
}

