/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoprotestocra;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaHeaderDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTraillerDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTransacaoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRelatorioRetornoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRemessaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaTituloDTO;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import br.com.elotech.tributos.enums.SituacaoProtestoTipoRemessa;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import br.com.elotech.tributos.service.integracaoprotestocra.servercra.ServerCraLocator;
import br.com.elotech.tributos.util.FileUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IntegracaoProtestoCraService {
    private static final String TIPO_ARQUIVO_REMESSA = "B";
    private final ProtestoRemessaService protestoRemessaService;
    private final ProtestoRemessaItemService protestoRemessaItemService;
    private final ProtestoService protestoService;
    private final ParametroGeralService parametroGeralService;
    private final EntidadeServiceImpl entidadeService;
    private ServerCraLocator serverCraLocator = new ServerCraLocator();

    public CraRelatorioRetornoDTO enviarRemessa(ProtestoRemessa protestoRemessa) {
        List protestoRemessaItems = this.protestoRemessaItemService.findByProtestoRemessa(protestoRemessa);
        CraRemessaDTO craRemessaDTO = this.createCraRemessaDTO(protestoRemessa, protestoRemessaItems);
        String userArq = craRemessaDTO.getNomeArquivo();
        String xmlEnvio = new String(this.marshalEnvio(craRemessaDTO).getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        URL url = this.getUrlFrom(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        String usuario = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String senha = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        AtomicReference<String> xmlRetorno = new AtomicReference<String>();
        try {
            xmlRetorno.set(new ServerCraLocator().getServerCraPort(url, usuario, senha).remessa(userArq, xmlEnvio));
        }
        catch (Exception e) {
            try {
                throw new EloValidationException("Erro ao enviar XML de remessa para o CRA. " + e.getMessage());
            }
            catch (Throwable throwable) {
                CraRelatorioRetornoDTO craRelatorioRetornoDTO = Objects.nonNull(xmlRetorno.get()) ? this.unmarshalRetorno((String)xmlRetorno.get()) : null;
                this.updateProtestoRemessaAfterEnviarRemessa(protestoRemessa, craRemessaDTO, xmlEnvio, (String)xmlRetorno.get());
                protestoRemessaItems.stream().map(ProtestoRemessaItem::getProtesto).forEach(protesto -> this.updateProtestoAfterEnviarRemessa(protesto, craRelatorioRetornoDTO));
                throw throwable;
            }
        }
        CraRelatorioRetornoDTO craRelatorioRetornoDTO = Objects.nonNull(xmlRetorno.get()) ? this.unmarshalRetorno((String)xmlRetorno.get()) : null;
        this.updateProtestoRemessaAfterEnviarRemessa(protestoRemessa, craRemessaDTO, xmlEnvio, (String)xmlRetorno.get());
        protestoRemessaItems.stream().map(ProtestoRemessaItem::getProtesto).forEach(protesto -> this.updateProtestoAfterEnviarRemessa(protesto, craRelatorioRetornoDTO));
        return craRelatorioRetornoDTO;
    }

    public CraRetornoConsultaTituloDTO consultarRemessa(Protesto protesto) throws MalformedURLException, JAXBException, RemoteException {
        if (Objects.isNull(protesto)) {
            throw new EloValidationException("O protesto \u00e9 obrigat\u00f3rio para a consulta de t\u00edtulos no CRA.");
        }
        ProtestoRemessaItem protestoRemessaItem = (ProtestoRemessaItem)this.protestoRemessaItemService.findByProtesto(protesto).orElseThrow(() -> new EloValidationException(String.format("Item da remessa do protesto n\u00e3o encontrado para o protesto %d", protesto.getId())));
        URL url = new URL(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        String usuario = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String senha = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String nossoNumero = protestoRemessaItem.getId().toString();
        String numeroTitulo = String.format("%d%d", protestoRemessaItem.getExercicioDocumento(), protestoRemessaItem.getDocumento());
        AtomicReference<String> xmlRetorno = new AtomicReference<String>(this.serverCraLocator.getServerCraPort(url, usuario, senha).consulta(nossoNumero, numeroTitulo));
        CraRetornoConsultaDTO craRetornoConsultaDTO = this.unmarshalRetornoConsulta(xmlRetorno.get());
        if (craRetornoConsultaDTO.isRetornoErro()) {
            throw new EloValidationException(craRetornoConsultaDTO.getOcorrencia());
        }
        if (craRetornoConsultaDTO.getTitulo().getSituacao().equals(protesto.getSituacao().getDescricaoCRA())) {
            return craRetornoConsultaDTO.getTitulo();
        }
        protesto.setSituacao(SituacaoProtesto.fromDescricaoCRA((String)craRetornoConsultaDTO.getTitulo().getSituacao()));
        this.protestoService.save((EloEntity)protesto, null);
        return craRetornoConsultaDTO.getTitulo();
    }

    private CraRemessaDTO createCraRemessaDTO(ProtestoRemessa protestoRemessa, List<ProtestoRemessaItem> protestoRemessaItems) {
        List protestoRemessaItemsFiltrados = protestoRemessaItems.stream().filter(ProtestoRemessaItem::isVinculoZeroOrPrincipal).collect(Collectors.toList());
        Long qtdeRegistrosTransacao = protestoRemessaItems.size();
        Long qtdeTitulosRemessa = protestoRemessaItemsFiltrados.size();
        EntidadeDTO entidadeDTO = this.getInfoEntidadePrincipal();
        CraComarcaHeaderDTO header = this.createCraComarcaHeaderDTO(entidadeDTO.getNome(), protestoRemessa.getRemessa(), qtdeRegistrosTransacao, qtdeTitulosRemessa);
        List transacoes = this.createCraComarcaTransacaoDTOS(header, entidadeDTO, protestoRemessaItemsFiltrados);
        CraComarcaTraillerDTO trailler = this.createCraComarcaTraillerDTO(header, transacoes);
        return CraRemessaDTO.builder().nomeArquivo(this.createNomeArquivoRemessa(header.getCodApresentante())).comarca(CraComarcaDTO.builder().codigoMunicipio(header.getCodMunicipio()).header(header).transacoes(transacoes).trailler(trailler).build()).build();
    }

    private CraComarcaHeaderDTO createCraComarcaHeaderDTO(String nomeApresentante, Long remessa, Long qtdeRegistrosTransacao, Long qtdeTitulosRemessa) {
        String codigoIbgeCartorio = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CODIGO_IBGE_CARTORIO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String codApresentante = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CODIGO_CONVENIO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return CraComarcaHeaderDTO.from((String)nomeApresentante, (Long)remessa, (String)codigoIbgeCartorio, (String)codApresentante, (Long)qtdeRegistrosTransacao, (Long)qtdeTitulosRemessa);
    }

    private List<CraComarcaTransacaoDTO> createCraComarcaTransacaoDTOS(CraComarcaHeaderDTO craComarcaHeaderDTO, EntidadeDTO entidadeDTO, List<ProtestoRemessaItem> protestoRemessaItems) {
        String usarVencimentoBloqueto = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.VENCIMENTO_BLOQUETO_REMESSA_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        AtomicLong sequencialRegistro = new AtomicLong(craComarcaHeaderDTO.getSequencialRegistro());
        AtomicLong sequencialDevedoresNoMesmoTitulo = new AtomicLong(1L);
        ArrayList<CraComarcaTransacaoDTO> transacoes = new ArrayList<CraComarcaTransacaoDTO>();
        protestoRemessaItems.forEach(protestoRemessaItem -> {
            String numTitulo = String.format("%s%s", protestoRemessaItem.getExercicioDocumento(), protestoRemessaItem.getDocumento());
            String imagemDocumentos = this.findImagemDocumentos(protestoRemessaItem.getProtesto());
            transacoes.forEach(transacao -> {
                if (numTitulo.equals(transacao.getNumTitulo())) {
                    sequencialDevedoresNoMesmoTitulo.incrementAndGet();
                } else {
                    sequencialDevedoresNoMesmoTitulo.set(1L);
                }
            });
            transacoes.add(CraComarcaTransacaoDTO.from((ProtestoRemessaItem)protestoRemessaItem, (String)imagemDocumentos, (String)craComarcaHeaderDTO.getCodApresentante(), (EntidadeDTO)entidadeDTO, (String)usarVencimentoBloqueto, (Long)sequencialDevedoresNoMesmoTitulo.get(), (Long)sequencialRegistro.incrementAndGet()));
        });
        return transacoes;
    }

    private String findImagemDocumentos(Protesto protesto) {
        byte[] zip = FileUtils.zipBytes((String)this.createNomeArquivoZip(protesto), (byte[])this.protestoService.findTermoProtestoS3(protesto));
        return Base64.getEncoder().encodeToString(zip);
    }

    private String createNomeArquivoZip(Protesto protesto) {
        return String.format("termo-protesto_%s_%s_%s", protesto.getProtesto(), protesto.getEntidade(), protesto.getExercicio());
    }

    private CraComarcaTraillerDTO createCraComarcaTraillerDTO(CraComarcaHeaderDTO header, List<CraComarcaTransacaoDTO> transacoes) {
        Long qtdeHeaders = 1L;
        Long qtdeTraillers = 1L;
        Long sequencialRegistroTrailler = header.getQtdeTitulosRemessa() + qtdeTraillers + qtdeHeaders;
        BigDecimal somatoriaSaldoTitulo = transacoes.stream().map(CraComarcaTransacaoDTO::getValorTitulo).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CraComarcaTraillerDTO.from((String)header.getNomeApresentante(), (String)header.getCodApresentante(), (Long)header.getSomatoriaSeguranca(), (Long)sequencialRegistroTrailler, (BigDecimal)somatoriaSaldoTitulo);
    }

    private EntidadeDTO getInfoEntidadePrincipal() {
        return (EntidadeDTO)this.entidadeService.getInfoEntidadePrincipal().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a entidade principal"));
    }

    private String createNomeArquivoRemessa(String codApresentante) {
        LocalDate dataAtual = LocalDate.now();
        String dataNomeArquivo = dataAtual.format(DateTimeFormatter.ofPattern("ddMM.yy"));
        Long qtdRemessaDiaAtual = this.protestoRemessaService.getQtdRemessaPorData(dataAtual, SituacaoProtestoTipoRemessa.R);
        Long qtdMaximaRemessaPorDia = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.QTD_MAX_REMESSA_DIA_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Long sequencialArquivo = qtdRemessaDiaAtual + 1L;
        if (qtdMaximaRemessaPorDia > 0L && qtdRemessaDiaAtual >= qtdMaximaRemessaPorDia) {
            throw new EloValidationException(String.format("A quantidade m\u00e1xima de remessas para este tipo j\u00e1 foi atingida para a data atual. Quantidade encontrada: %d remessa(s) enviada(s). Limite por dia: %d remessa(s).", qtdRemessaDiaAtual, qtdMaximaRemessaPorDia));
        }
        return String.format("%s%s%s%d", TIPO_ARQUIVO_REMESSA, codApresentante, dataNomeArquivo, sequencialArquivo);
    }

    private String marshalEnvio(CraRemessaDTO craRemessaDTO) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRemessaDTO.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)craRemessaDTO, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter objeto em XML. " + e.getMessage());
        }
    }

    private URL getUrlFrom(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException mee) {
            throw new EloValidationException("Erro ao converter texto em URL. " + mee.getMessage());
        }
    }

    private CraRelatorioRetornoDTO unmarshalRetorno(String xmlRetorno) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRelatorioRetornoDTO.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (CraRelatorioRetornoDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter XML de retorno do CRA. " + e.getMessage());
        }
    }

    private void updateProtestoRemessaAfterEnviarRemessa(ProtestoRemessa protestoRemessa, CraRemessaDTO craRemessaDTO, String xmlEnvio, String xmlRetorno) {
        protestoRemessa.setArqenvData(LocalDate.parse(craRemessaDTO.getComarca().getHeader().getDataEnvioRemessa(), DateTimeFormatter.ofPattern("ddMMyyyy")));
        protestoRemessa.setArqenvUsuario(protestoRemessa.getUsuario());
        protestoRemessa.setArqenvArquivo(xmlEnvio.getBytes());
        protestoRemessa.setArqenvArquivonome(craRemessaDTO.getNomeArquivo());
        protestoRemessa.setTotalRegistros(craRemessaDTO.getComarca().getHeader().getQtdeRegistrosTransacao());
        protestoRemessa.setXmlRetorno(xmlRetorno);
        this.protestoRemessaService.save((EloEntity)protestoRemessa, null);
    }

    private void updateProtestoAfterEnviarRemessa(Protesto protesto, CraRelatorioRetornoDTO craRelatorioRetornoDTO) {
        if (Objects.isNull(craRelatorioRetornoDTO)) {
            return;
        }
        if (Objects.isNull(craRelatorioRetornoDTO.getComarcas())) {
            return;
        }
        craRelatorioRetornoDTO.getComarcas().forEach(comarca -> {
            if (comarca.isRegistrosOk()) {
                protesto.setSituacao(SituacaoProtesto.GERADO);
                this.protestoService.save((EloEntity)protesto, null);
            }
        });
    }

    private CraRetornoConsultaDTO unmarshalRetornoConsulta(String xmlRetorno) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRetornoConsultaDTO.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (CraRetornoConsultaDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
    }

    @Generated
    public IntegracaoProtestoCraService(ProtestoRemessaService protestoRemessaService, ProtestoRemessaItemService protestoRemessaItemService, ProtestoService protestoService, ParametroGeralService parametroGeralService, EntidadeServiceImpl entidadeService) {
        this.protestoRemessaService = protestoRemessaService;
        this.protestoRemessaItemService = protestoRemessaItemService;
        this.protestoService = protestoService;
        this.parametroGeralService = parametroGeralService;
        this.entidadeService = entidadeService;
    }

    @Generated
    public void setServerCraLocator(ServerCraLocator serverCraLocator) {
        this.serverCraLocator = serverCraLocator;
    }
}

