/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoteCdaItemService
extends CrudService<LoteCdaItem, Long> {
    private final LoteCdaItemRepository loteCdaItemRepository;

    public void beforeSave(LoteCdaItem entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    public SituacaoLoteCda getSituacaoLoteByItemId(Long itemId) {
        return this.loteCdaItemRepository.getSituacaoLote(itemId);
    }

    public LoteCdaItem findByIdLoteAndIdDebito(Long idLote, Long idDebito) {
        return this.loteCdaItemRepository.findByIdLoteAndIdDebito(idLote, idDebito);
    }

    public LoteCdaItem findByIdLoteAndIdCadastroGeral(Long idLote, Long idCadastroGeral) {
        return this.loteCdaItemRepository.findByIdLoteAndIdCadastroGeral(idLote, idCadastroGeral);
    }

    public void deleteById(Long id) {
        SituacaoLoteCda situacaoLote = this.loteCdaItemRepository.getSituacaoLote(id);
        if (Objects.isNull(situacaoLote)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar item");
        }
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)situacaoLote)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover itens de lote com situa\u00e7\u00e3o diferente de %s", SituacaoLoteCda.SIMULACAO_GERADA.getDescricao()));
        }
        this.loteCdaItemRepository.deleteById((Object)id);
    }

    public Page<LoteCdaItem> findLoteCdaItem(Long idLoteCda, String search, Sort sort, Integer totalCdas) {
        String idClause = String.format("lote.id==%d", idLoteCda);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, (Pageable)PageRequest.of((int)0, (int)totalCdas, (Sort)sort));
    }

    public Optional<LoteCdaItem> findByDocumento(Long idDocumento) {
        return this.loteCdaItemRepository.findByDocumento(idDocumento);
    }

    public Long getNextItemSequenceByLoteId(Long idLote) {
        return this.loteCdaItemRepository.getNextItemSequenceByLoteId(idLote);
    }

    @Generated
    public LoteCdaItemService(LoteCdaItemRepository loteCdaItemRepository) {
        this.loteCdaItemRepository = loteCdaItemRepository;
    }
}

