/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.dto.documento.cda.DeleteCDASimulacaoItemDetalheDTO;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemDetalheRepository;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemService;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoteCdaItemDetalheService {
    private final LoteCdaItemDetalheRepository loteCdaItemDetalheRepository;
    private final LoteCdaItemService loteCdaItemService;

    public void deletePorParcela(DeleteCDASimulacaoItemDetalheDTO dto) {
        SituacaoLoteCda situacaoLote = this.loteCdaItemService.getSituacaoLoteByItemId(dto.getIdItem());
        if (Objects.isNull(situacaoLote)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar detalhe do item");
        }
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)situacaoLote)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover detalhes de item de lote com situa\u00e7\u00e3o diferente de %s", SituacaoLoteCda.SIMULACAO_GERADA.getDescricao()));
        }
        List itemsToRemove = this.loteCdaItemDetalheRepository.findAllByParcelaAndIdItem(dto.getIdItem(), dto.getEntidade(), dto.getExercicio(), dto.getDivida(), dto.getSubDivida(), dto.getParcela());
        this.loteCdaItemDetalheRepository.deleteAll((Iterable)itemsToRemove);
    }

    public void updateValoresByDocumentoItemDividaAtiva(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        this.loteCdaItemService.findByDocumento(documentoItemDividaAtiva.getDocumento().getId()).ifPresent(loteCdaItem -> loteCdaItem.getItemDetalhes().forEach(loteCdaItemDetalhe -> {
            if (this.isSameParcelaTributo(loteCdaItemDetalhe.getParcelaTributo(), documentoItemDividaAtiva)) {
                loteCdaItemDetalhe.setValor(documentoItemDividaAtiva.getValor());
                loteCdaItemDetalhe.setValorJuros(documentoItemDividaAtiva.getValorJuros());
                loteCdaItemDetalhe.setValorMulta(documentoItemDividaAtiva.getValorMulta());
                loteCdaItemDetalhe.setValorCorrecao(documentoItemDividaAtiva.getValorCorrecao());
                this.loteCdaItemDetalheRepository.saveAndFlush(loteCdaItemDetalhe);
            }
        }));
    }

    private boolean isSameParcelaTributo(DebitoParcelaTributo debitoParcelaTributo, DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        return Objects.equals(debitoParcelaTributo.getEntidade(), documentoItemDividaAtiva.getDocumento().getEntidade()) && Objects.equals(debitoParcelaTributo.getExercicio(), documentoItemDividaAtiva.getExercicioDebito()) && Objects.equals(debitoParcelaTributo.getTipoCadastro(), documentoItemDividaAtiva.getTipoCadastro()) && Objects.equals(debitoParcelaTributo.getCadastroGeral(), documentoItemDividaAtiva.getCadastroGeral()) && Objects.equals(debitoParcelaTributo.getDivida(), documentoItemDividaAtiva.getCodigoDivida()) && Objects.equals(debitoParcelaTributo.getTributo(), documentoItemDividaAtiva.getTributo()) && Objects.equals(debitoParcelaTributo.getParcela(), documentoItemDividaAtiva.getParcela());
    }

    @Generated
    public LoteCdaItemDetalheService(LoteCdaItemDetalheRepository loteCdaItemDetalheRepository, LoteCdaItemService loteCdaItemService) {
        this.loteCdaItemDetalheRepository = loteCdaItemDetalheRepository;
        this.loteCdaItemService = loteCdaItemService;
    }
}

