/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.ProtestoDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.ProtestoRepository;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.RelatorioService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.util.LongUtils;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DocumentoProtestoService {
    private final AiseRelatorioService aiseRelatorioService;
    private final EntidadeRepository entidadeRepository;
    private final ParametroGeralService parametroGeralService;
    private final RelatorioService relatorioService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final ProtestoService protestoService;
    private final GeraBoletoService geraBoletoService;
    private final AisePdfService aisePdfService;
    private final ResolversHandler resolversHandler;
    private final ProtestoRepository protestoRepository;
    private static final String PARAM_FORMAT = "%s=%s%n";

    public void agruparDocumentoEnvioCRA(List<ProtestoDTO> protestosDTO) throws IOException {
        ArrayList protestos = new ArrayList(this.protestoRepository.findAllById((Iterable)protestosDTO.stream().map(ProtestoDTO::getId).collect(Collectors.toList())));
        for (Protesto protesto : protestos) {
            if (!Objects.isNull(protesto.getIdTermoProtestoS3())) continue;
            PDDocument document = new PDDocument();
            byte[] termoProtesto = this.printTermoProtesto(protesto.getDocumento());
            this.mergeInfoToDocument(document, termoProtesto);
            byte[] certidaoDividaAtivaInfo = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(protesto.getDocumento().getId());
            this.mergeInfoToDocument(document, certidaoDividaAtivaInfo);
            List boletos = this.createBloqueto(protesto);
            if (Objects.isNull(boletos) || boletos.isEmpty()) {
                throw new EloValidationException("Erro ao gerar boleto");
            }
            for (Bloqueto boleto : boletos) {
                byte[] infoBoleto;
                ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto.getBloqueto(), boleto.getExercicioBloqueto()));
                try (InputStream inputBoletoDoTermo = new URL(impressaoDTO.getUrl()).openStream();){
                    infoBoleto = inputBoletoDoTermo.readAllBytes();
                }
                this.mergeInfoToDocument(document, infoBoleto);
            }
            InputStream fileStream = this.saveDocument(document);
            try {
                ArquivoNovoRequest arquivoNovoRequest = this.createNewFileRequest(protesto.getId(), fileStream);
                Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
                protesto.setIdTermoProtestoS3(arquivo.getId());
                this.protestoService.save((EloEntity)protesto, null);
            }
            finally {
                if (fileStream == null) continue;
                fileStream.close();
            }
        }
    }

    public byte[] printTermoProtesto(Documento documento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoTermoProtesto(documento);
        byte[] arquivo = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        return arquivo;
    }

    private List<Bloqueto> createBloqueto(Protesto protesto) {
        DocumentoItemDividaAtiva primeiroDocumentoItemDividaAtiva = (DocumentoItemDividaAtiva)protesto.getDocumento().getDocumentoItemDividaAtivas().stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado divida ativa para o protesto %d/%d", protesto.getProtesto(), protesto.getExercicio())));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setDataReferencia(this.getUltimoDiaDoMes(LocalDate.now()));
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        geraBoletoDTO.setDebitos(this.getDebitoParcelaDtoFromProtesto(primeiroDocumentoItemDividaAtiva.getDebito()));
        return this.geraBoletoService.geraBoleto(geraBoletoDTO);
    }

    private ImprimirRelatorioDTO buildImpressaoTermoProtesto(Documento documento) {
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento n\u00e3o encontrado");
        }
        Long relatorioTermoProtesto = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIO_TERMO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String tipoRelatorioTermoProtesto = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_RELATORIO_TERMO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (LongUtils.isNullOrZero((Long)relatorioTermoProtesto) || StringUtils.isEmpty((String)tipoRelatorioTermoProtesto)) {
            throw new EloValidationException("Relat\u00f3rio termo protesto e Tipo Relat\u00f3rio termo protesto n\u00e3o configurado");
        }
        Relatorio relatorio = (Relatorio)this.relatorioService.findOne((Serializable)RelatorioPK.from((String)ModuloEnum.MODULO_TRIBUTARIO.getValue(), (TipoRelatorio)TipoRelatorio.fromValue((String)tipoRelatorioTermoProtesto), (Integer)relatorioTermoProtesto.intValue()));
        if (Objects.isNull(relatorio)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Relat\u00f3rio n\u00e3o encontrado");
        }
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        String parametro = String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PExercicio", documento.getExercicio())).concat(String.format(PARAM_FORMAT, "PDescUF", unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, "PCidade", this.getCidadeDescricao(entidadeprincipal.getCidade())));
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorioFromEnum(relatorio.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" DOC.Exercicio = %d and DOC.Documento = %d and DOC.TipoDocumento = %d ", documento.getExercicio(), documento.getDocumento(), documento.getTipoDocumento()));
        dto.setSubReports(this.createSubReportDTO(dto.getFiltro()));
        dto.setListParametros(parametro);
        return dto;
    }

    private String getCidadeDescricao(Cidade cidade) {
        if (Optional.ofNullable(cidade).isEmpty()) {
            return "";
        }
        return cidade.getDescricao();
    }

    private SubReportDTO createSubReportDTO(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Cabecalho", ""), new SubReportItemDTO("ProtestoTermo", filtro), new SubReportItemDTO("ProtestoProprietario", filtro)}));
        return subReportDTO;
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        try {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
        }
        catch (Exception ex) {
            throw new IOException(String.format("Erro ao juntar documentos. %s", ex.getMessage()));
        }
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private LocalDate getUltimoDiaDoMes(LocalDate data) {
        YearMonth yearMonth = YearMonth.from(data);
        int ultimoDia = yearMonth.lengthOfMonth();
        return data.withDayOfMonth(ultimoDia);
    }

    private List<DebitoParcelaDTO> getDebitoParcelaDtoFromProtesto(Debito debito) {
        return debito.getParcelas().stream().map(parcela -> DebitoParcelaDTO.convertBoleto((DebitoParcela)parcela, (Long)debito.getId())).collect(Collectors.toList());
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private ArquivoNovoRequest createNewFileRequest(Long idProtesto, InputStream inputStream) {
        String nomeArquivo = String.format("Protesto_CDA_CRA_%d_%s", idProtesto, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public DocumentoProtestoService(AiseRelatorioService aiseRelatorioService, EntidadeRepository entidadeRepository, ParametroGeralService parametroGeralService, RelatorioService relatorioService, CertidaoDividaAtivaService certidaoDividaAtivaService, ProtestoService protestoService, GeraBoletoService geraBoletoService, AisePdfService aisePdfService, ResolversHandler resolversHandler, ProtestoRepository protestoRepository) {
        this.aiseRelatorioService = aiseRelatorioService;
        this.entidadeRepository = entidadeRepository;
        this.parametroGeralService = parametroGeralService;
        this.relatorioService = relatorioService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.protestoService = protestoService;
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
        this.resolversHandler = resolversHandler;
        this.protestoRepository = protestoRepository;
    }
}

