/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.comunicado;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.dto.ComunicadoServiceDTO;
import br.com.elotech.tributos.enums.OrigemComunicado;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.TipoNotificacaoComunicadoService;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.joda.time.LocalDate;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoLivroDaJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private static final String LIVRO = "livro";
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    @Qualifier(value="comunicadoLivroDaBatchJob")
    private final Job comunicadoLivroDaBatchJob;
    private final ComunicadoRepository comunicadoRepository;
    private final TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService;

    public ComunicadoLivroDaJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="comunicadoLivroDaBatchJob") Job comunicadoLivroDaBatchJob, ComunicadoRepository comunicadoRepository, TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.comunicadoLivroDaBatchJob = comunicadoLivroDaBatchJob;
        this.comunicadoRepository = comunicadoRepository;
        this.tipoNotificacaoComunicadoService = tipoNotificacaoComunicadoService;
    }

    public JobExecution startJob(ComunicadoServiceDTO comunicadoServiceDTO) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.COMUNICADO_LIVRO_DIVIDA_ATIVA.getTipo()).stream().anyMatch(job -> comunicadoServiceDTO.getIdentificador().get(LIVRO).equals(Objects.requireNonNull(job.getJobParameters().getLong(LIVRO))) && comunicadoServiceDTO.getIdentificador().get(ENTIDADE).equals(Objects.requireNonNull(job.getJobParameters().getLong(ENTIDADE))) && comunicadoServiceDTO.getIdentificador().get(EXERCICIO).equals(Objects.requireNonNull(job.getJobParameters().getLong(EXERCICIO))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setEntidade(Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get(ENTIDADE))));
        idComunicado.setExercicio(Long.valueOf(LocalDate.now().getYear()));
        TipoNotificacaoComunicado tipoNotificacao = this.tipoNotificacaoComunicadoService.findById((Serializable)comunicadoServiceDTO.getTipoNotificacao().getId()).orElse(null);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        comunicado.setDescricao(comunicadoServiceDTO.getDescricao());
        if (Objects.nonNull(tipoNotificacao)) {
            comunicado.setTipoNotificacao(tipoNotificacao);
            comunicado.setRelatorio(tipoNotificacao.getRelatorio());
        }
        comunicado.setDataValidade(comunicadoServiceDTO.getDataValidade());
        comunicado.setDataGeracao(comunicadoServiceDTO.getDataGeracao());
        comunicado.setUsuario(comunicadoServiceDTO.getUsuario());
        comunicado.setOrigem(OrigemComunicado.LIVRO_DA);
        comunicado = (Comunicado)this.comunicadoRepository.save((Object)comunicado);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong(LIVRO, Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get(LIVRO))));
        jobParametersBuilder.addLong(ENTIDADE, Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get(ENTIDADE))));
        jobParametersBuilder.addLong(EXERCICIO, Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get(EXERCICIO))));
        jobParametersBuilder.addLong("idComunicado", comunicado.getId().getIdComunicado());
        jobParametersBuilder.addLong("exercicioComunicado", idComunicado.getExercicio());
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.comunicadoLivroDaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

