/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.mobiliario.IssRegimeEspecialTributacaoXsd;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.IssRegimeEspecialTributacaoXsdDTO;
import br.com.elotech.tributos.dto.RegimeFiscalDTO;
import br.com.elotech.tributos.repository.IssRegimeEspecialTributacaoXsdRepository;
import br.com.elotech.tributos.repository.RegimeFiscalRepository;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class RegimeFiscalService
extends ReadOnlyService<RegimeFiscal, Long> {
    private final RegimeFiscalRepository regimeFiscalRepository;
    private final IssRegimeEspecialTributacaoXsdRepository issRegimeEspecialTributacaoXsdRepository;

    public RegimeFiscalService(RegimeFiscalRepository regimeFiscalRepository, IssRegimeEspecialTributacaoXsdRepository issRegimeEspecialTributacaoXsdRepository) {
        this.regimeFiscalRepository = regimeFiscalRepository;
        this.issRegimeEspecialTributacaoXsdRepository = issRegimeEspecialTributacaoXsdRepository;
    }

    public RegimeFiscalDTO save(RegimeFiscalDTO regimeFiscalDTO) {
        Long idRegimeFiscal = regimeFiscalDTO.getId();
        if (this.regimeFiscalRepository.findById((Object)idRegimeFiscal).isPresent()) {
            throw new EloValidationException(String.format("Regime fiscal %d j\u00e1 existe!", idRegimeFiscal));
        }
        this.validateIssRegimeEspecialTributacaoXsd(regimeFiscalDTO.getIssRegimeEspecialTributacaoXsd());
        return RegimeFiscalDTO.of((RegimeFiscal)((RegimeFiscal)this.regimeFiscalRepository.save((Object)RegimeFiscal.from((RegimeFiscalDTO)regimeFiscalDTO))));
    }

    public RegimeFiscalDTO edit(Long idRegimeFiscal, RegimeFiscalDTO regimeFiscalDTO) {
        RegimeFiscal regimeFiscal = (RegimeFiscal)this.regimeFiscalRepository.findById((Object)idRegimeFiscal).orElseThrow(() -> new EloValidationException(String.format("Regime fiscal %d n\u00e3o encontrado!", idRegimeFiscal)));
        IssRegimeEspecialTributacaoXsdDTO issRegimeEspecialTributacaoXsd = regimeFiscalDTO.getIssRegimeEspecialTributacaoXsd();
        this.validateIssRegimeEspecialTributacaoXsd(issRegimeEspecialTributacaoXsd);
        regimeFiscal.setDescricao(regimeFiscalDTO.getDescricao());
        regimeFiscal.setIssRegimeEspecialTributacaoXsd(IssRegimeEspecialTributacaoXsd.from((IssRegimeEspecialTributacaoXsdDTO)issRegimeEspecialTributacaoXsd));
        regimeFiscal.setIssGeraDebito(regimeFiscalDTO.getIssGeraDebito());
        regimeFiscal.setSimplesNacional(regimeFiscalDTO.getSimplesNacional());
        regimeFiscal.setMei(regimeFiscalDTO.getMei());
        regimeFiscal.setAliqZero(regimeFiscalDTO.getAliqZero());
        regimeFiscal.setAtivo(regimeFiscalDTO.getAtivo());
        return RegimeFiscalDTO.of((RegimeFiscal)((RegimeFiscal)this.regimeFiscalRepository.save((Object)regimeFiscal)));
    }

    public void delete(Long idRegimeFiscal) {
        if (!this.regimeFiscalRepository.findById((Object)idRegimeFiscal).isPresent()) {
            throw new EloValidationException(String.format("Regime fiscal %d n\u00e3o encontrado!", idRegimeFiscal));
        }
        this.regimeFiscalRepository.deleteById((Object)idRegimeFiscal);
    }

    private void validateIssRegimeEspecialTributacaoXsd(IssRegimeEspecialTributacaoXsdDTO issRegimeEspecialTributacaoXsdDTO) {
        Long idIssRegimeEspecialTributacaoXsd = Optional.ofNullable(issRegimeEspecialTributacaoXsdDTO).map(IssRegimeEspecialTributacaoXsdDTO::getId).orElse(null);
        if (Objects.nonNull(idIssRegimeEspecialTributacaoXsd) && !this.issRegimeEspecialTributacaoXsdRepository.findById((Object)idIssRegimeEspecialTributacaoXsd).isPresent()) {
            throw new EloValidationException(String.format("Regime especial XSD %d n\u00e3o existe!", idIssRegimeEspecialTributacaoXsd));
        }
    }
}

