/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.lib.painel.dto.NotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificacaoService.class);
    private final Publisher publisher;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Optional<UUID> send(String title, String detail, JobExecution jobExecution, Optional<UUID> notificationId, NotificationStatus status) {
        try {
            UUID id = notificationId.orElse(UUID.randomUUID());
            NotificationDTO notification = NotificationDTO.builder().id(id).userId(SecurityUtils.getUserId()).username(SecurityUtils.getUserAise()).link(String.format("/tributos/tarefas?tipoFiltro=LOTE&filters==instanceId_Igual=%d", jobExecution.getJobId())).modulo(Modulo.OXY_TRIBUTOS.toString()).message(title).messageDetail(Optional.ofNullable(detail).orElse(title)).status(status).type("Lote").build();
            this.publishNotification(notificationId, notification);
            return Optional.of(id);
        }
        catch (Exception e) {
            log.error("Erro ao notificar usu\u00e1rio: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Optional<UUID> send(String title, String detail, TarefaAssincrona tarefa, Optional<UUID> notificationId, UserSecurityDTO userSecurityDTO, NotificationStatus status) {
        try {
            UUID id = notificationId.orElse(UUID.randomUUID());
            NotificationDTO notification = NotificationDTO.builder().id(id).userId(Optional.ofNullable(userSecurityDTO.getUserId()).orElse(SecurityUtils.getUserId())).username(Optional.ofNullable(userSecurityDTO.getPreferredUsername()).orElse(SecurityUtils.getUserAise())).link(String.format("/tributos/tarefas?tipoFiltro=TAREFA&filters==id_Igual=%d", tarefa.getId())).modulo(Modulo.OXY_TRIBUTOS.toString()).message(title).messageDetail(Optional.ofNullable(detail).orElse(title)).status(status).type("Tarefa").build();
            this.publishNotification(notificationId, notification);
            return Optional.of(id);
        }
        catch (Exception e) {
            log.error("Erro ao notificar usu\u00e1rio: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    private void publishNotification(Optional<UUID> notificationId, NotificationDTO notificationDTO) {
        OutboxActions action = notificationId.isPresent() ? OutboxActions.UPDATED : OutboxActions.CREATED;
        this.publisher.publish(action, (EntityEvent)notificationDTO);
    }

    @Generated
    public NotificacaoService(Publisher publisher) {
        this.publisher = publisher;
    }
}

