/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.enums.TipoMovimentacaoTributo;
import br.com.elotech.tributos.params.MovimentacaoTributoParams;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MovimentacaoTributoService {
    private static final String DATE_FORMAT_PATTERN = "dd/MM/yyyy";
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final PagamentoService pagamentoService;

    public Page<MovimentacaoTributoDTO> findMovimentacoes(MovimentacaoTributoParams params, Pageable pageable) {
        this.validateMovimentacaoTributoParams(params);
        TipoMovimentacaoTributo tipo = params.getTipoMovimentacaoTributo();
        if (TipoMovimentacaoTributo.shouldFindInCancelamento((TipoMovimentacaoTributo)tipo)) {
            return this.cancelamentoDebitoService.findMovimentacoes(params, pageable);
        }
        if (TipoMovimentacaoTributo.shouldFindInPagamento((TipoMovimentacaoTributo)tipo)) {
            return this.pagamentoService.findMovimentacoes(params, pageable);
        }
        return Page.empty();
    }

    private void validateMovimentacaoTributoParams(MovimentacaoTributoParams params) {
        if (TipoMovimentacaoTributo.CADUCIDADE.equals((Object)params.getTipoMovimentacaoTributo())) {
            this.validateDataMaximaParaBusca(params.getDataFinal());
        } else {
            this.validateDataMinimaParaBusca(params.getDataInicial());
        }
    }

    private void validateDataMinimaParaBusca(LocalDate dataInicial) {
        LocalDate dataAtualComMenosCincoAnos = LocalDate.now().minusYears(5L);
        if (dataInicial.isBefore(dataAtualComMenosCincoAnos)) {
            throw new EloValidationException(String.format("A Data Inicial (%s) deve trazer informa\u00e7\u00f5es at\u00e9 os \u00faltimos 5 anos. A data m\u00ednima para busca \u00e9 %s", dataInicial.format(DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN)), dataAtualComMenosCincoAnos.format(DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN))));
        }
    }

    private void validateDataMaximaParaBusca(LocalDate dataFinal) {
        LocalDate dataAtualComMenosCincoAnos = LocalDate.now().minusYears(5L);
        if (dataFinal.isAfter(dataAtualComMenosCincoAnos)) {
            throw new EloValidationException(String.format("A Data Final (%s) deve ter menos de 5 anos com base na data atual para a busca de caducidades. A data m\u00e1xima para busca \u00e9 %s", dataFinal.format(DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN)), dataAtualComMenosCincoAnos.format(DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN))));
        }
    }

    @Generated
    public MovimentacaoTributoService(CancelamentoDebitoService cancelamentoDebitoService, PagamentoService pagamentoService) {
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.pagamentoService = pagamentoService;
    }
}

