/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Caucao;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioCaucao;
import br.com.elotech.tributos.dto.CaucaoDTO;
import br.com.elotech.tributos.repository.CaucaoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioCaucaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class CaucaoService
extends CrudService<Caucao, Long> {
    private final CaucaoRepository caucaoRepository;
    private final CadastroImobiliarioCaucaoRepository cadastroImobiliarioCaucaoRepository;
    private final CadastroGeralService cadastroGeralService;
    private final EntidadeRepository entidadeRepository;

    public Caucao create(CaucaoDTO caucaoDTO) {
        Caucao caucao = this.createAndSaveCaucao(caucaoDTO);
        caucaoDTO.getCadastros().forEach(cadastro -> {
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(cadastro.getTipoCadastro(), cadastro.getCadastroGeral()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral n\u00e3o encontrado para o tipo %s e c\u00f3digo %s", cadastro.getTipoCadastro(), cadastro.getCadastroGeral())));
            this.cadastroImobiliarioCaucaoRepository.save((Object)this.createCadastroImobiliarioCaucao(cadastroGeral, caucao));
        });
        return caucao;
    }

    public CaucaoDTO findOneById(Long id) {
        Caucao caucao = (Caucao)this.caucaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Cau\u00e7\u00e3o n\u00e3o encontrada"));
        List cadastroImobiliarioCaucao = this.cadastroImobiliarioCaucaoRepository.findByCaucaoCaucao(caucao.getCaucao());
        return CaucaoDTO.from((Caucao)caucao, (List)cadastroImobiliarioCaucao);
    }

    private Caucao createAndSaveCaucao(CaucaoDTO caucaoDTO) {
        Caucao caucao = Objects.isNull(caucaoDTO.getId()) ? new Caucao() : (Caucao)this.caucaoRepository.findById((Object)caucaoDTO.getId()).orElseThrow(() -> new EloValidationException(String.format("Cau\u00e7\u00e3o %d n\u00e3o encontrada", caucaoDTO.getId())));
        Entidade entidade = this.entidadeRepository.findByEntidadeprincipal();
        if (Objects.isNull(caucao.getCaucao())) {
            caucao.setCaucao(this.caucaoRepository.findMaxCaucaoByEntidadeId(entidade.getId()));
        }
        caucao.setEntidade(entidade);
        caucao.setNumeroAlvara(caucaoDTO.getNumeroAlvara());
        caucao.setTipoCaucao(caucaoDTO.getTipoCaucao());
        caucao.setDataInclusao(LocalDate.now());
        caucao.setMotivo(caucaoDTO.getObservacao());
        caucao.setAto(caucaoDTO.getMotivo());
        return (Caucao)this.caucaoRepository.save((Object)caucao);
    }

    private CadastroImobiliarioCaucao createCadastroImobiliarioCaucao(CadastroGeral cadastroGeral, Caucao caucao) {
        CadastroImobiliarioCaucao cadastroImobiliarioCaucao = this.cadastroImobiliarioCaucaoRepository.findByCaucaoCaucaoAndCadastroGeral(caucao.getCaucao(), cadastroGeral.getCadastroGeral(), cadastroGeral.getTipoCadastro()).orElse(new CadastroImobiliarioCaucao());
        if (Objects.isNull(cadastroImobiliarioCaucao.getCadastroGeral())) {
            cadastroImobiliarioCaucao.setCadastroGeral(cadastroGeral);
        }
        cadastroImobiliarioCaucao.setCaucao(caucao);
        cadastroImobiliarioCaucao.setLiberado(Boolean.TRUE);
        cadastroImobiliarioCaucao.setDataLiberacao(LocalDate.now());
        cadastroImobiliarioCaucao.setUsuario(SecurityUtils.getUserAise());
        return cadastroImobiliarioCaucao;
    }

    @Generated
    public CaucaoService(CaucaoRepository caucaoRepository, CadastroImobiliarioCaucaoRepository cadastroImobiliarioCaucaoRepository, CadastroGeralService cadastroGeralService, EntidadeRepository entidadeRepository) {
        this.caucaoRepository = caucaoRepository;
        this.cadastroImobiliarioCaucaoRepository = cadastroImobiliarioCaucaoRepository;
        this.cadastroGeralService = cadastroGeralService;
        this.entidadeRepository = entidadeRepository;
    }
}

