/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroRuralDTO;
import br.com.elotech.tributos.dto.CadastroRuralRowDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastrorural.CadastroRuralEnderecoDTO;
import br.com.elotech.tributos.dto.cadastrorural.CadastroRuralItbiDTO;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroRural;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.rural.CadastroRuralRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.SequenceCadastroGeralService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CadastroRuralService
extends CrudService<CadastroRural, Long> {
    private final HibernateSearchService hibernateSearchService;
    private final CadastroRuralRepository cadastroRuralRepository;
    private final ParametroEntidadeService parametroEntidadeService;
    private final SequenceCadastroGeralService sequenceCadastroGeralService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ContextService contextService;
    private final RespostaService respostaService;

    public CadastroRuralService(HibernateSearchService hibernateSearchService, CadastroRuralRepository cadastroRuralRepository, ParametroEntidadeService parametroEntidadeService, SequenceCadastroGeralService sequenceCadastroGeralService, SequenceGeneratorRepository sequenceGeneratorRepository, ContextService contextService, RespostaService respostaService) {
        this.hibernateSearchService = hibernateSearchService;
        this.cadastroRuralRepository = cadastroRuralRepository;
        this.parametroEntidadeService = parametroEntidadeService;
        this.sequenceCadastroGeralService = sequenceCadastroGeralService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.contextService = contextService;
        this.respostaService = respostaService;
    }

    public CadastroSearchDTO<CadastroRuralRowDTO> searchCadastrosRurais(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "pessoa.nome", "pessoa.cnpjCpf", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "logradouro.logradouro", "logradouroDescricao", "bairro.bairro", "bairroDescricao", "complemento", "nomePropriedade", "endereco", "distrito.id", "distrito.descricao", "setor.setor", "setor.apelido", "lote", "matricula");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroRural.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroRural.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.RURAL.getDescricao())).should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).should(hibernateSearchParams.createFuzzyQuery()).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroRuralRowDTO::from);
    }

    public void deleteById(Long id) {
        CadastroRural cadastroRural = this.findCadastroRuralById(id);
        this.cadastroRuralRepository.delete((Object)cadastroRural);
    }

    protected void beforeSave(CadastroRural cadastroRural, Authentication authentication) {
        cadastroRural.setDataAlteracao(this.contextService.getDataAtual());
        cadastroRural.setUsuario(SecurityUtils.getUserAise());
        if (!this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroRural.getCadastroGeral())) {
            cadastroRural.setCadastroGeral(this.getCadastroGeralBySequence(cadastroRural));
            cadastroRural.atualizaReferenciaObservacoes();
        }
        this.setPessoaCadastroGeral(cadastroRural);
        cadastroRural.updateReferenciaRespostaRural();
        super.beforeSave((EloEntity)cadastroRural, authentication);
    }

    private void setPessoaCadastroGeral(CadastroRural cadastroRural) {
        Proprietario proprietarioPrincipal = cadastroRural.getProprietarios().stream().filter(proprietario -> proprietario.getPrincipal() != false && TipoVinculo.PRINCIPAL.equals((Object)proprietario.getVinculo().getTipoVinculo())).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o h\u00e1 um propriet\u00e1rio marcado como principal"));
        cadastroRural.setPessoa(proprietarioPrincipal.getPessoa());
    }

    private Long getCadastroGeralBySequence(CadastroRural cadastroRural) {
        String sequenceNome = this.sequenceCadastroGeralService.getExpression((CadastroGeral)cadastroRural);
        return this.sequenceGeneratorRepository.getNextVal(sequenceNome);
    }

    private CadastroRural findCadastroRuralById(Long id) {
        return (CadastroRural)this.cadastroRuralRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro rural com o id %d n\u00e3o encontrado.", id)));
    }

    public CadastroRuralDTO findCadastroRuralDTO(Long id) {
        CadastroRuralDTO retorno = CadastroRuralDTO.from((CadastroRural)this.findCadastroRuralById(id));
        retorno.setRespostasRurais(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.RURAL, id));
        return retorno;
    }

    private Boolean informaCadastroManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_RURAL_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private void validaCamposObrigatorios(CadastroRuralDTO cadastroRuralDTO) {
        if (this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroRuralDTO.getCadastroGeral())) {
            throw new EloValidationException("O c\u00f3digo do cadastro deve ser informado.");
        }
    }

    private void validaCamposDinamicosObrigatorios(CadastroRural cadastroRural) {
        this.respostaService.validaRespostas(cadastroRural.getRespostasRurais(), FuncionalidadeCampo.RURAL);
    }

    public CadastroRuralDTO save(CadastroRuralDTO cadastroRuralDTO) {
        this.validaCamposObrigatorios(cadastroRuralDTO);
        CadastroRural cadastroRural = cadastroRuralDTO.toEntity();
        this.validaCamposDinamicosObrigatorios(cadastroRural);
        CadastroRuralDTO retorno = CadastroRuralDTO.from((CadastroRural)((CadastroRural)this.save((EloEntity)cadastroRural, null)));
        retorno.setRespostasRurais(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.RURAL, retorno.getId()));
        return retorno;
    }

    public CadastroRuralDTO update(Long id, CadastroRuralDTO cadastroRuralDTO) {
        this.validaCamposObrigatorios(cadastroRuralDTO);
        CadastroRural cadastroRuralToMerge = cadastroRuralDTO.toEntity();
        CadastroRural cadastroRuralFound = this.findCadastroRuralById(id);
        if (!cadastroRuralToMerge.getId().equals(cadastroRuralFound.getId())) {
            throw new EloValidationException("Para atualizar os dados, os cadastros devem ser os mesmos.");
        }
        CadastroRural cadastroRuralMerged = cadastroRuralFound.merge(cadastroRuralToMerge);
        this.validaCamposDinamicosObrigatorios(cadastroRuralMerged);
        return CadastroRuralDTO.from((CadastroRural)((CadastroRural)this.save((EloEntity)cadastroRuralMerged, null)));
    }

    public CadastroRuralItbiDTO getCadastroRuralParaItbi(Long cadastro) {
        return this.cadastroRuralRepository.findByCadastroGeral(cadastro).map(CadastroRuralItbiDTO::from).orElse(null);
    }

    public CadastroRuralEnderecoDTO getEnderecoByCadastroRural(Long cadastro) {
        CadastroRural cadastroRural = (CadastroRural)this.cadastroRuralRepository.findByCadastroGeral(cadastro).orElseThrow(() -> new EloValidationException("Cadastro Rural n\u00e3o encontrado"));
        CadastroRuralEnderecoDTO cadastroRuralEnderecoDTO = new CadastroRuralEnderecoDTO();
        cadastroRuralEnderecoDTO.setId(cadastroRural.getId());
        cadastroRuralEnderecoDTO.setTipoCadastro(cadastroRural.getTipoCadastro());
        cadastroRuralEnderecoDTO.setCadastroGeral(cadastroRural.getCadastroGeral());
        cadastroRuralEnderecoDTO.setCidade(cadastroRural.getCidade());
        Optional.ofNullable(cadastroRural.getLogradouro()).ifPresent(logradouro -> cadastroRuralEnderecoDTO.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        cadastroRuralEnderecoDTO.setNumero(cadastroRural.getNumero());
        Optional.ofNullable(cadastroRural.getCep()).ifPresent(cep -> cadastroRuralEnderecoDTO.setCep(cep.toString()));
        cadastroRuralEnderecoDTO.setComplemento(cadastroRural.getComplemento());
        Optional.ofNullable(cadastroRural.getBairro()).ifPresent(bairro -> cadastroRuralEnderecoDTO.setBairro(BairroDTO.from((Bairro)bairro)));
        return cadastroRuralEnderecoDTO;
    }
}

