/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.sanepar;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.sanepar.BaixaSanepar;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparDTO;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparItemDTO;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparTotalizadorDTO;
import br.com.elotech.tributos.dto.sanepar.ImportacaoBaixaSaneparDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.sanepar.BaixaSaneparService;
import br.com.elotech.tributos.service.sanepar.ImportacaoSaneparJobStarter;
import br.com.elotech.tributos.service.sanepar.ProcessamentoSaneparJobStarter;
import br.com.elotech.tributos.service.sanepar.ProcessamentoSaneparService;
import br.com.elotech.tributos.service.sanepar.VerificacaoSaneparJobStarter;
import br.com.elotech.tributos.service.sanepar.VerificacaoSaneparService;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/baixa-sanepar"})
public class BaixaSaneparResource {
    private final BaixaSaneparService baixaSaneparService;
    private final VerificacaoSaneparService verificaoService;
    private final ImportacaoSaneparJobStarter importacaoSaneparJobStarter;
    private final ProcessamentoSaneparService processamentoSaneparService;
    private final ProcessamentoSaneparJobStarter processamentoSaneparJobStarter;
    private final VerificacaoSaneparJobStarter verificacaoSaneparJobStarter;

    @PostMapping(value={"/importar"})
    public ResponseEntity<BaixaSaneparDTO> importarLote(ImportacaoBaixaSaneparDTO importacaoDto, @RequestParam MultipartFile file) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, IOException {
        String fileContent = new String(file.getBytes(), StandardCharsets.UTF_8);
        String hash = DigestUtils.sha256Hex((String)fileContent);
        this.baixaSaneparService.findByHash(hash).ifPresent(loteExistente -> {
            throw new EloValidationException(String.format("Esse arquivo j\u00e1 foi importado no lote %d.", loteExistente.getId()));
        });
        BaixaSanepar baixaSanepar = this.baixaSaneparService.createLoteAberto(importacaoDto, file.getOriginalFilename(), SecurityUtils.getUserAise());
        this.baixaSaneparService.uploadArquivo(baixaSanepar, file, hash);
        this.importacaoSaneparJobStarter.startJob(baixaSanepar);
        return ResponseEntity.ok((Object)BaixaSaneparDTO.from((BaixaSanepar)baixaSanepar));
    }

    @GetMapping
    public ResponseEntity<Page<BaixaSaneparDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.baixaSaneparService.findByRsql(search, pageable).map(BaixaSaneparDTO::from);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<BaixaSaneparDTO> findOne(@PathVariable(value="id") Long id) {
        return this.baixaSaneparService.findById((Serializable)id).map(BaixaSaneparDTO::from).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<BaixaSaneparItemDTO>> searchItens(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.baixaSaneparService.searchItens(id, search, pageable);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/{idBaixa}/itens/{idItem}/verificar"})
    public ResponseEntity<Boolean> verificarLoteSanepar(@PathVariable(value="idBaixa") Long idBaixa, @PathVariable(value="idItem") Long iditem) {
        this.verificaoService.verificar(idBaixa, iditem);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idBaixa}/itens/verificar"})
    public ResponseEntity<Void> verificarLoteSaneparBatch(@PathVariable(value="idBaixa") Long idBaixa) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        user.validateIfExists();
        this.verificacaoSaneparJobStarter.startJob(idBaixa);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idBaixa}/itens/{idItem}/baixar"})
    public ResponseEntity<Void> baixarLoteSaneparItem(@PathVariable(value="idBaixa") Long idBaixa, @PathVariable(value="idItem") Long iditem) {
        this.processamentoSaneparService.processarBaixaIndividual(idBaixa, iditem);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idBaixa}/itens/baixar"})
    public ResponseEntity<Void> baixarLoteSaneparBatch(@PathVariable(value="idBaixa") Long idBaixa) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        user.validateIfExists();
        this.processamentoSaneparJobStarter.startJob(idBaixa);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/totalizador"})
    public ResponseEntity<BaixaSaneparTotalizadorDTO> getTotalizador(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.baixaSaneparService.getTotalizador(id));
    }

    @PostMapping(value={"/imprimir-inconsistencia-baixa/{idBaixa}"})
    public void imprimirInconsistenciaArquivoBaixa(@PathVariable(value="idBaixa") Long idBaixa, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.baixaSaneparService.imprimirInconsistenciaArquivoBaixa(idBaixa);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o arquivo de inconsist\u00eancia de baixa!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"inconsistenciabaixa.pdf");
    }

    @Generated
    public BaixaSaneparResource(BaixaSaneparService baixaSaneparService, VerificacaoSaneparService verificaoService, ImportacaoSaneparJobStarter importacaoSaneparJobStarter, ProcessamentoSaneparService processamentoSaneparService, ProcessamentoSaneparJobStarter processamentoSaneparJobStarter, VerificacaoSaneparJobStarter verificacaoSaneparJobStarter) {
        this.baixaSaneparService = baixaSaneparService;
        this.verificaoService = verificaoService;
        this.importacaoSaneparJobStarter = importacaoSaneparJobStarter;
        this.processamentoSaneparService = processamentoSaneparService;
        this.processamentoSaneparJobStarter = processamentoSaneparJobStarter;
        this.verificacaoSaneparJobStarter = verificacaoSaneparJobStarter;
    }
}

