/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.mobile;

import br.com.elotech.tributos.dto.mobile.PropriedadeMobileDTO;
import br.com.elotech.tributos.dto.mobile.TipoCadastroMobileDTO;
import br.com.elotech.tributos.params.DebitoAVencerParams;
import br.com.elotech.tributos.service.mobile.PropriedadeMobileService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mobile/propriedades"})
public class PropriedadeMobileResource {
    private final PropriedadeMobileService propriedadeMobileService;

    public PropriedadeMobileResource(PropriedadeMobileService propriedadeMobileService) {
        this.propriedadeMobileService = propriedadeMobileService;
    }

    @PostMapping(path={"debitos-por-periodo"})
    public ResponseEntity<List<PropriedadeMobileDTO>> getPropriedadesDebitoEmAbertoByCpfCnpjAndDataVencimento(@RequestBody DebitoAVencerParams params) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedadesByListCpfCnpjAndDataVencimento(params.getInscricoes(), params.getDiasAVencer()));
    }

    @GetMapping(path={"/debito-emaberto"}, params={"cpf-cnpj"})
    public ResponseEntity<List<PropriedadeMobileDTO>> getPropriedadesByCpfCnpj(@RequestParam(value="cpf-cnpj") String cpfCnpj) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedades(cpfCnpj));
    }

    @GetMapping(path={"/paginado/debito-emaberto"}, params={"cpf-cnpj"})
    public ResponseEntity<Page<PropriedadeMobileDTO>> getPagedPropriedadesByCpfCnpj(@RequestParam(value="cpf-cnpj") String cpfCnpj, Pageable pageable) {
        List allRecords = this.propriedadeMobileService.findPropriedades(cpfCnpj);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }

    @GetMapping(params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<PropriedadeMobileDTO> getPropriedadeByTipoAndCodigo(@RequestParam(value="tipo-cadastro") Integer tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedadeByTipoAndCodigo(tipoCadastro, cadastroGeral));
    }

    @GetMapping(path={"/tipos"}, params={"cpf-cnpj"})
    public ResponseEntity<List<TipoCadastroMobileDTO>> findTipoCadastroByCpfCnpj(@RequestParam(value="cpf-cnpj") String cpfCnpj) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findTipoCadastroByCpfCnpj(cpfCnpj));
    }

    @GetMapping(params={"tipo-cadastro", "cpf-cnpj"})
    public ResponseEntity<List<PropriedadeMobileDTO>> findPropriedadesByCpfCnpjAndTipoCadastro(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cpf-cnpj") String cpfCnpj) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedadesByCpfCnpjAndTipoCadastro(cpfCnpj, tipoCadastro));
    }

    @GetMapping(path={"/paginado"}, params={"tipo-cadastro", "cpf-cnpj"})
    public ResponseEntity<Page<PropriedadeMobileDTO>> findPagedPropriedadesByCpfCnpjAndTipoCadastro(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cpf-cnpj") String cpfCnpj, Pageable pageable) {
        List allRecords = this.propriedadeMobileService.findPropriedadesByCpfCnpjAndTipoCadastro(cpfCnpj, tipoCadastro);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }

    @GetMapping(params={"cpf-cnpj"})
    public ResponseEntity<List<PropriedadeMobileDTO>> findPropriedadesByCpfCnpj(@RequestParam(value="cpf-cnpj") String cpfCnpj) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedadesByCpfCnpj(cpfCnpj));
    }

    @GetMapping(path={"/paginado"}, params={"cpf-cnpj"})
    public ResponseEntity<Page<PropriedadeMobileDTO>> findPagedPropriedadesByCpfCnpj(@RequestParam(value="cpf-cnpj") String cpfCnpj, Pageable pageable) {
        List allRecords = this.propriedadeMobileService.findPropriedadesByCpfCnpj(cpfCnpj);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }

    @GetMapping(path={"/paginado/{cpfCnpj}"})
    public ResponseEntity<Page<PropriedadeMobileDTO>> getPropriedadeByTipoAndCadastroAndCpfCnpj(@PathVariable String cpfCnpj, @RequestParam Optional<String> search, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.propriedadeMobileService.findPropriedadesByCpfCnpjAndTipoAndCodigo(cpfCnpj, search, pageable));
    }
}

