/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoboleto;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.batch.UpdateCodigoBarrasQRCodeJobStarter;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixReceiver;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.IntegracaoPixPagoContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-boleto"})
public class IntegracaoBoletoResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoResource.class);
    private final IntegracaoPixReceiver integracaoPixReceiver;
    private final BloquetoService bloquetoService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;
    private final ConvenioService convenioService;
    private final IntegracaoPixPagoContext integracaoPixPagoContext;
    private final UpdateCodigoBarrasQRCodeJobStarter updateCodigoBarrasQRCodeJobStarter;
    private final ParametroGeralService parametroGeralService;

    @PostMapping(value={"/{id}/geraqrcodepix"})
    public ResponseEntity<IntegracaoPixResponseDTO> gerarQrCode(@PathVariable Long id) {
        log.debug("Iniciando requisi\u00e7\u00e3o para gerar QR Code do boleto {}", (Object)id);
        Bloqueto bloqueto = (Bloqueto)this.bloquetoService.findById((Serializable)id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Bloqueto n\u00e3o encontrado"));
        log.debug("Boleto {} encontrado", (Object)id);
        Bloqueto boleto = this.bloquetoService.save(this.integracaoPixReceiver.gerarQrCodePix(bloqueto));
        IntegracaoPixResponseDTO integracaoPixResponseDTO = new IntegracaoPixResponseDTO();
        integracaoPixResponseDTO.setTextoQrCode(boleto.getTextoQrCode());
        integracaoPixResponseDTO.setTxid(boleto.getTxidPix());
        log.debug("Finalizando requisi\u00e7\u00e3o para gerar QR Code do boleto {}", (Object)id);
        return ResponseEntity.ok((Object)integracaoPixResponseDTO);
    }

    @PostMapping(value={"/{id}/registrageraqrcodepix"})
    public ResponseEntity<IntegracaoPixResponseDTO> registrarGerarQrCode(@PathVariable Long id) {
        Bloqueto boleto = (Bloqueto)this.bloquetoService.findById((Serializable)id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Bloqueto n\u00e3o encontrado"));
        if (!Boolean.TRUE.equals(boleto.getModeloBloqueto().getConvenio().getRegistraBoletoOnline())) {
            throw new EloValidationException(String.format("O conv\u00eanio do boleto n\u00e3o est\u00e1 configurado para registro on-line: Conv\u00eanio %d", boleto.getModeloBloqueto().getConvenio().getId()));
        }
        CodigoBarrasDTO codigoBarrasDTO = this.integracaoBoletoRegistradoReceiver.receiveRequest(boleto);
        codigoBarrasDTO.validaDadosCodigoBarras();
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        IntegracaoPixResponseDTO integracaoPixResponseDTO = new IntegracaoPixResponseDTO();
        Boolean permiteRegistroSemQrCode = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_REGISTRO_SEM_QRCODE);
        try {
            boleto = this.bloquetoService.save(this.integracaoPixReceiver.gerarQrCodePix(boleto));
            integracaoPixResponseDTO.setTextoQrCode(boleto.getTextoQrCode());
            integracaoPixResponseDTO.setTxid(boleto.getTxidPix());
        }
        catch (Exception e) {
            if (!permiteRegistroSemQrCode.booleanValue()) {
                throw e;
            }
            log.error("Erro ao gerar qrCode, por\u00e9m est\u00e1 permitindo registrar o boleto sem qrcode", (Throwable)e);
        }
        return ResponseEntity.ok((Object)integracaoPixResponseDTO);
    }

    @PutMapping(value={"/{id}/alterarvencimento/{vencimento}"})
    public ResponseEntity<String> alterarVencimento(@PathVariable Long id, @PathVariable String vencimento) {
        Bloqueto bloqueto = (Bloqueto)this.bloquetoService.findById((Serializable)id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Bloqueto n\u00e3o encontrado"));
        this.bloquetoService.save(this.integracaoBoletoRegistradoReceiver.updateVencimentoBoleto(bloqueto, LocalDate.parse(vencimento)));
        return ResponseEntity.ok((Object)"Boleto alterado com sucesso");
    }

    @GetMapping(value={"/consultarpagamentopix/{idConvenio}"})
    public ResponseEntity<ConsultaPixResponseDTO> getPagamentoPix(@PathVariable Long idConvenio, @RequestParam(required=false, name="e2eId") Optional<String> e2eId, @RequestParam(required=false, name="txid") Optional<String> txid) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)idConvenio).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("Conv\u00eanio n\u00e3o encontrado com o id %d.", idConvenio)));
        if (txid.isEmpty() && e2eId.isEmpty()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio informar o e2eId ou txid para consultar.");
        }
        try {
            return ResponseEntity.ok((Object)this.integracaoPixReceiver.getPagamentoPix(txid, e2eId, convenio));
        }
        catch (RestException e) {
            return ResponseEntity.ok((Object)new ConsultaPixResponseDTO(SimNao.NAO.getSigla(), e.getMessage()));
        }
    }

    @GetMapping(value={"/{idConvenio}/webhook"})
    public ResponseEntity getWebHook(@PathVariable Long idConvenio) {
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idConvenio}/webhook/pix"})
    public ResponseEntity<IntegracaoPixPagoLog> getWebHookPix(@PathVariable Long idConvenio, @RequestBody JsonNode pixPagos) {
        return ResponseEntity.ok((Object)this.integracaoPixPagoContext.processarPixPagosWebHook(pixPagos, idConvenio));
    }

    @GetMapping(value={"/atualiza-codigo-barras-boleto-itau"})
    public ResponseEntity<Void> updateCodigoBarrasBoleto() throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.updateCodigoBarrasQRCodeJobStarter.startJob();
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"{idBoleto}/atualiza-codigo-barras-boleto-itau"})
    public ResponseEntity<IntegracaoBoletoPixLog> updateCodigoBarrasUmBoleto(@PathVariable Long idBoleto) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        CodigoBarrasQrCodePixItauDTO codigoBarrasQrCodePixItauDTO = this.bloquetoService.findBloquetoNaoPagoAndcnab750arquivodetalhe(idBoleto);
        return ResponseEntity.ok((Object)this.integracaoPixReceiver.updateCodigoBarrasBoleto(codigoBarrasQrCodePixItauDTO));
    }

    @Generated
    public IntegracaoBoletoResource(IntegracaoPixReceiver integracaoPixReceiver, BloquetoService bloquetoService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver, ConvenioService convenioService, IntegracaoPixPagoContext integracaoPixPagoContext, UpdateCodigoBarrasQRCodeJobStarter updateCodigoBarrasQRCodeJobStarter, ParametroGeralService parametroGeralService) {
        this.integracaoPixReceiver = integracaoPixReceiver;
        this.bloquetoService = bloquetoService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
        this.convenioService = convenioService;
        this.integracaoPixPagoContext = integracaoPixPagoContext;
        this.updateCodigoBarrasQRCodeJobStarter = updateCodigoBarrasQRCodeJobStarter;
        this.parametroGeralService = parametroGeralService;
    }
}

