/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.RastreamentoService;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rastreamento"})
public class RastreamentoResource {
    private final RastreamentoService rastreamentoService;
    private final CadastroGeralService cadastroGeralService;

    public RastreamentoResource(RastreamentoService rastreamentoService, CadastroGeralService cadastroGeralService) {
        this.rastreamentoService = rastreamentoService;
        this.cadastroGeralService = cadastroGeralService;
    }

    @GetMapping(value={"/cadastro/{idCadastro}"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porCadastro(@PathVariable Long idCadastro) {
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoService.porCadastro(idCadastro)));
    }

    @GetMapping(value={"/contribuinte/{idContribuinte}"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porContribuinte(@PathVariable Long idContribuinte) {
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoService.porContribuinte(idContribuinte)));
    }

    @GetMapping(value={"/contribuinte"})
    public ResponseEntity<List<RastreamentoCadastroDTO>> porContribuinteUtilizandoCadastro(@RequestParam(value="idCadastro") Long idCadastro) {
        Pessoa responsavel = this.cadastroGeralService.getResponsavel(idCadastro);
        return ResponseEntity.ok((Object)this.ordenarCadastros(this.rastreamentoService.porContribuinte(responsavel.getId())));
    }

    private List<RastreamentoCadastroDTO> ordenarCadastros(Set<RastreamentoCadastroDTO> cadastros) {
        return cadastros.stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toList());
    }
}

