/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.dto.MotivoDeducaoDTO;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/motivos-deducao"})
public class MotivoDeducaoResource
extends CrudResource<MotivoDeducao, Long> {
    private final MotivoDeducaoService motivoDeducaoService;

    public MotivoDeducaoResource(MotivoDeducaoService motivoDeducaoService) {
        this.motivoDeducaoService = motivoDeducaoService;
    }

    @GetMapping(value={"/sem-movimentacao/{id}"})
    public ResponseEntity<MotivoDeducao> findByMotivoId(@PathVariable(value="id") Long motivoId) {
        return ResponseEntity.ok((Object)this.motivoDeducaoService.findByMotivoId(motivoId));
    }

    @GetMapping(value={"/autocomplete-simplificado"})
    public ResponseEntity<Page<MotivoDeducaoDTO>> findByEntidadeExercicioAndDescricao(@RequestParam Long exercicio, @RequestParam Long entidade, @RequestParam String descricao, Pageable pageable) {
        return ResponseEntity.ok().body((Object)this.motivoDeducaoService.findByEntidadeExercicioAndDescricao(exercicio, entidade, descricao, pageable));
    }

    @PostMapping(value={"/{id}/valida-edicao"})
    public ResponseEntity<Void> validaMotivoMovimentacao(@PathVariable(value="id") Long motivoId) {
        this.motivoDeducaoService.validaMotivoMovimentacao(motivoId);
        return ResponseEntity.ok().build();
    }
}

