/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Caucao;
import br.com.elotech.tributos.dto.CaucaoDTO;
import br.com.elotech.tributos.repository.CaucaoRepository;
import br.com.elotech.tributos.service.CaucaoService;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/caucoes"})
public class CaucaoResource
extends CrudResource<Caucao, Long> {
    private final CaucaoRepository caucaoRepository;
    private final CaucaoService caucaoService;

    @GetMapping(value={"/caucao/{caucao}"})
    public ResponseEntity<Caucao> findOneNaturalKey(@PathVariable(value="caucao") Long caucao, @RequestHeader(value="entidade") Long entidade) {
        Caucao caucaoObj = this.caucaoRepository.findByEntidadeIdAndCaucao(entidade, caucao);
        return ResponseEntity.ok((Object)caucaoObj);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Caucao> create(@RequestBody @Valid CaucaoDTO caucao) {
        Caucao caucaoObj = this.caucaoService.create(caucao);
        return ResponseEntity.ok((Object)caucaoObj);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Caucao> update(@RequestBody @Valid CaucaoDTO caucao) {
        Caucao caucaoObj = this.caucaoService.create(caucao);
        return ResponseEntity.ok((Object)caucaoObj);
    }

    @GetMapping(value={"/find/{id}"})
    public ResponseEntity<CaucaoDTO> findOneById(@PathVariable(value="id") Long caucao) {
        return ResponseEntity.ok((Object)this.caucaoService.findOneById(caucao));
    }

    @Generated
    public CaucaoResource(CaucaoRepository caucaoRepository, CaucaoService caucaoService) {
        this.caucaoRepository = caucaoRepository;
        this.caucaoService = caucaoService;
    }
}

