/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.ConferenciaArquivoDTO;
import br.com.elotech.tributos.repository.simam.MovimentacaoMensalCustomRepository;
import br.com.elotech.tributos.service.ExercicioMesService;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConferenciaRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final MovimentacaoMensalCustomRepository movimentacaoMensalCustomRepository;
    private final ExercicioMesService exercicioMesService;

    public ConferenciaRepository(NamedParameterJdbcTemplate jdbcTemplate, MovimentacaoMensalCustomRepository movimentacaoMensalCustomRepository, ExercicioMesService exercicioMesService) {
        this.jdbcTemplate = jdbcTemplate;
        this.movimentacaoMensalCustomRepository = movimentacaoMensalCustomRepository;
        this.exercicioMesService = exercicioMesService;
    }

    public List<ConferenciaArquivoDTO> getConferenciaByData(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        String sqlInterna = String.join((CharSequence)" union all ", FileUtils.readResourceAsString((String)"sql/simam/conferencia/LancamentoCredito.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoLancamentoCredito.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/AtualizacaoMonetariaNoExercicio.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoAtualizacaoMonetariaNoExercicio.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/DeducaoLancamentoCredito.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoDeducaoLancamentoCredito.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/InscricaoCreditoDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoInscricaoCreditoDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/AtualizacaoMonetariaDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoAtualizacaoMonetariaDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/DeducaoInscricaoDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoDeducaoInscricaoDividaAtiva.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/ArrecadacaoPorTipoCredito.sql"), FileUtils.readResourceAsString((String)"sql/simam/conferencia/EstornoArrecadacaoPorTipoCredito.sql"));
        String sql = String.format("select filtro.codigoArquivo as codigo,       filtro.arquivo as nome,        coalesce(filtro.valorArquivo, 0)                                      as valorArquivo,        coalesce(filtro.valorIntegrado, 0)                                    as valorIntegrado,        coalesce(filtro.valorRetencao,0)                                      as valorRetencao,         filtro.tipoArquivo as tipo from (%s) as filtro ", sqlInterna);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("dataInicial", (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue("dataFinal", (Object)Date.valueOf(dataFinal), 91);
        parameters.addValue("mes", (Object)dataInicial.getMonthValue(), 4);
        parameters.addValue("ano", (Object)dataInicial.getYear(), 4);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ConferenciaArquivoDTO.class));
    }

    public void limpaMesByIntervaloDeDatas(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        this.exercicioMesService.validaMesAberto(Long.valueOf(dataInicial.getMonthValue()), Long.valueOf(dataInicial.getYear()));
        this.movimentacaoMensalCustomRepository.clearMovimentacao(entidade, dataInicial, dataFinal);
    }
}

