/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.ArrecadacaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.ArrecadacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoCreditoCustomRepositoryImpl
implements ArrecadacaoCreditoCustomRepository {
    private final String sqlCargaExistente = FileUtils.readResourceAsString((String)"sql/simam/arrecadacaoCreditoCargaExistente.sql");
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<ArrecadacaoCreditoCargaExistenteDTO> getCargaExistente(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        return this.namedParameterJdbcTemplate.query(this.sqlCargaExistente, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoCreditoCargaExistenteDTO.class));
    }

    public List<ArrecadacaoCreditoDTO> findArrecadacoes(Long idPessoa, Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue("mes", (Object)dataInicial.getMonthValue());
        parameters.addValue("ano", (Object)dataInicial.getYear());
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/arrecadacaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoCreditoDTO.class));
    }

    @Generated
    public ArrecadacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

