/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.documento.cda;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface LoteCdaItemRepository
extends CrudRepository<LoteCdaItem, Long> {
    @Query(value=" select lci.lote.situacao from LoteCdaItem lci where lci.id = :id")
    public SituacaoLoteCda getSituacaoLote(@Param(value="id") Long var1);

    @Query(value="select lci from LoteCdaItem lci inner join lci.itemDetalhes lcid inner join lcid.parcelaTributo dpt inner join dpt.debitoParcela dp inner join dp.debito d where lci.lote.id = :idLote and d.id = :idDebito")
    public LoteCdaItem findByIdLoteAndIdDebito(@Param(value="idLote") Long var1, @Param(value="idDebito") Long var2);

    @Query(value="select lci from LoteCdaItem lci where lci.lote.id = :idLote and lci.cadastroGeral.id = :idCadastroGeral")
    public LoteCdaItem findByIdLoteAndIdCadastroGeral(@Param(value="idLote") Long var1, @Param(value="idCadastroGeral") Long var2);

    @Query(value="select lci from LoteCdaItem lci where lci.documento.id = :idDocumento")
    public Optional<LoteCdaItem> findByDocumento(@Param(value="idDocumento") Long var1);

    @Query(value="SELECT COALESCE(MAX(sequencia),0) + 1 FROM LoteCdaItem item WHERE item.lote.id = :idLote ")
    public Long getNextItemSequenceByLoteId(Long var1);
}

