/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.cancelamento;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import java.time.LocalDate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface CancelamentoDebitoRepository
extends CrudRepository<CancelamentoDebito, CancelamentoDebitoPk> {
    @Query(value="SELECT CASE WHEN COUNT(*) > 0 THEN 'TRUE' ELSE 'FALSE' END FROM TRIBCANCELAMENTODEBITOITEM TCDI INNER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TCDI.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA INNER JOIN TRIBCADASTROGERAL TCG ON TDPR.TIPOCADASTRO = TCG.TIPOCADASTRO AND TDPR.CADASTROGERAL = TCG.CADASTROGERAL WHERE TCDI.ENTIDADE = ?1 AND TCDI.EXERCICIO = ?2 AND TCDI.IDCANCELAMENTO = ?3 AND TCG.EXCLUSAOLOGICA = 'S' ", nativeQuery=true)
    public Boolean possuiCadastroComExclusaoLogica(Long var1, Long var2, Long var3);

    @Query(value="select new br.com.elotech.tributos.dto.MovimentacaoTributoDTO(cast(cd.dataCancelamento as LocalDate) as dataSituacao, p.cnpjCpf as cpfCnpj, p.nome as contribuinte, t.descricao as especie, md.descricao as justificativa, cdi.valor as valor) from CancelamentoDebito cd join CancelamentoDebitoItem cdi on cd.id.id = cdi.id.cancelamentoDebito.id.id     and cd.id.entidade=cdi.id.cancelamentoDebito.id.entidade      and cd.id.exercicio=cdi.id.cancelamentoDebito.id.exercicio join cdi.id.debitoParcelaTributo dpt join CadastroGeral cg on dpt.tipoCadastro = cg.tipoCadastro      and dpt.cadastroGeral = cg.cadastroGeral join cg.pessoa p join Tributo t on dpt.entidade = t.entidade      and dpt.exercicio = t.exercicio      and dpt.tributo = t.tributo join cd.motivoCancelamento md where cd.dataCancelamento between :dataInicial and :dataFinal and md.tipoDeducao.id = :tipoMovimentacaoTributo and p.cnpjCpf like ('%'||:cpfCnpj||'%') and lower(p.nome) like lower(('%'||:contribuinte||'%')) ")
    public Page<MovimentacaoTributoDTO> findMovimentacoes(LocalDate var1, LocalDate var2, Long var3, String var4, String var5, Pageable var6);
}

