/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.repository.PagamentoRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PagamentoRepository
extends CrudRepository<Pagamento, PagamentoId>,
PagamentoRepositoryCustom {
    @Query(value=" select CASE WHEN count(pag.pagamento) > 0 THEN 'TRUE' ELSE 'FALSE' END AS exist  from   tribpagamento pag  inner join tribpagamentobloqueto pbloq          on pbloq.entidade = pag.entidade         and pbloq.exerciciopagamento = pag.exerciciopagamento         and pbloq.pagamento = pag.pagamento   inner join tribbloqueto bloq          on pbloq.entidade = bloq.entidade         and pbloq.exerciciobloqueto = bloq.exerciciobloqueto         and pbloq.bloqueto = bloq.bloqueto  where  bloq.idkey = :idBoleto    and  pag.pagoamenor = 'N'    and  not exists (select 1                     from   tribestornopagamento est                     where  est.pagamento = pag.pagamento                     and    est.exerciciopagamento = pag.exerciciopagamento                     and    est.entidade = pag.entidade                     and    coalesce(est.reabilitado, 'N') = 'N' )", nativeQuery=true)
    public Boolean existePagamentoNaoEstornadoByIdBoleto(@Param(value="idBoleto") Long var1);

    public List<Pagamento> findByLoteId(PagamentoLoteId var1);

    @Query(value="select new br.com.elotech.tributos.dto.MovimentacaoTributoDTO(cast(pg.dataMovimento as LocalDate) as dataSituacao, p.cnpjCpf as cpfCnpj, p.nome as contribuinte, t.descricao as especie, md.descricao as justificativa, pd.valorDesconto as valor) from Pagamento pg join pg.pagamentoBoleto pb join pb.motivoDeducao md join pb.pagamentosDebito pd join pd.id.debitoParcelaTributo dpt join CadastroGeral cg on dpt.tipoCadastro = cg.tipoCadastro      and dpt.cadastroGeral = cg.cadastroGeral join cg.pessoa p join Tributo t on dpt.entidade = t.entidade      and dpt.exercicio = t.exercicio      and dpt.tributo = t.tributo where pg.dataMovimento between :dataInicial and :dataFinal and md.tipoDeducao.id = :tipoMovimentacaoTributo and p.cnpjCpf like ('%'||:cpfCnpj||'%') and lower(p.nome) like lower(('%'||:contribuinte||'%')) and pd.valorDesconto > 0 ")
    public Page<MovimentacaoTributoDTO> findMovimentacoes(LocalDate var1, LocalDate var2, Long var3, String var4, String var5, Pageable var6);
}

